/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.axis.v1_20;

import com.google.api.ads.dfa.axis.v1_20.AdRemote;
import com.google.api.ads.dfa.axis.v1_20.AdRemoteService;
import com.google.api.ads.dfa.axis.v1_20.AdSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class AdRemoteServiceLocator
extends Service
implements AdRemoteService {
    private String ad_address = "https://advertisersapi.doubleclick.net/v1.20/api/dfa-api/ad";
    private String adWSDDServiceName = "ad";
    private HashSet ports = null;

    public AdRemoteServiceLocator() {
    }

    public AdRemoteServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public AdRemoteServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getadAddress() {
        return this.ad_address;
    }

    public String getadWSDDServiceName() {
        return this.adWSDDServiceName;
    }

    public void setadWSDDServiceName(String name) {
        this.adWSDDServiceName = name;
    }

    public AdRemote getad() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.ad_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getad(endpoint);
    }

    public AdRemote getad(URL portAddress) throws ServiceException {
        try {
            AdSoapBindingStub _stub = new AdSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getadWSDDServiceName());
            return _stub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setadEndpointAddress(String address) {
        this.ad_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (AdRemote.class.isAssignableFrom(serviceEndpointInterface)) {
                AdSoapBindingStub _stub = new AdSoapBindingStub(new URL(this.ad_address), this);
                _stub.setPortName(this.getadWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("ad".equals(inputPortName)) {
            return this.getad();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://www.doubleclick.net/dfa-api/v1.20", "AdRemoteService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://www.doubleclick.net/dfa-api/v1.20", "ad"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"ad".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setadEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

