/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfa.axis.v1_20;

import com.google.api.ads.dfa.axis.v1_20.NetworkRemote;
import com.google.api.ads.dfa.axis.v1_20.NetworkRemoteService;
import com.google.api.ads.dfa.axis.v1_20.NetworkSoapBindingStub;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceException;
import org.apache.axis.AxisFault;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Service;
import org.apache.axis.client.Stub;

public class NetworkRemoteServiceLocator
extends Service
implements NetworkRemoteService {
    private String network_address = "https://advertisersapi.doubleclick.net/v1.20/api/dfa-api/network";
    private String networkWSDDServiceName = "network";
    private HashSet ports = null;

    public NetworkRemoteServiceLocator() {
    }

    public NetworkRemoteServiceLocator(EngineConfiguration config) {
        super(config);
    }

    public NetworkRemoteServiceLocator(String wsdlLoc, QName sName) throws ServiceException {
        super(wsdlLoc, sName);
    }

    public String getnetworkAddress() {
        return this.network_address;
    }

    public String getnetworkWSDDServiceName() {
        return this.networkWSDDServiceName;
    }

    public void setnetworkWSDDServiceName(String name) {
        this.networkWSDDServiceName = name;
    }

    public NetworkRemote getnetwork() throws ServiceException {
        URL endpoint;
        try {
            endpoint = new URL(this.network_address);
        }
        catch (MalformedURLException e) {
            throw new ServiceException((Throwable)e);
        }
        return this.getnetwork(endpoint);
    }

    public NetworkRemote getnetwork(URL portAddress) throws ServiceException {
        try {
            NetworkSoapBindingStub _stub = new NetworkSoapBindingStub(portAddress, this);
            _stub.setPortName(this.getnetworkWSDDServiceName());
            return _stub;
        }
        catch (AxisFault axisFault) {
            return null;
        }
    }

    public void setnetworkEndpointAddress(String address) {
        this.network_address = address;
    }

    public Remote getPort(Class serviceEndpointInterface) throws ServiceException {
        try {
            if (NetworkRemote.class.isAssignableFrom(serviceEndpointInterface)) {
                NetworkSoapBindingStub _stub = new NetworkSoapBindingStub(new URL(this.network_address), this);
                _stub.setPortName(this.getnetworkWSDDServiceName());
                return _stub;
            }
        }
        catch (Throwable t) {
            throw new ServiceException(t);
        }
        throw new ServiceException("There is no stub implementation for the interface:  " + (serviceEndpointInterface == null ? "null" : serviceEndpointInterface.getName()));
    }

    public Remote getPort(QName portName, Class serviceEndpointInterface) throws ServiceException {
        if (portName == null) {
            return this.getPort(serviceEndpointInterface);
        }
        String inputPortName = portName.getLocalPart();
        if ("network".equals(inputPortName)) {
            return this.getnetwork();
        }
        Remote _stub = this.getPort(serviceEndpointInterface);
        ((Stub)_stub).setPortName(portName);
        return _stub;
    }

    public QName getServiceName() {
        return new QName("http://www.doubleclick.net/dfa-api/v1.20", "NetworkRemoteService");
    }

    public Iterator getPorts() {
        if (this.ports == null) {
            this.ports = new HashSet();
            this.ports.add(new QName("http://www.doubleclick.net/dfa-api/v1.20", "network"));
        }
        return this.ports.iterator();
    }

    public void setEndpointAddress(String portName, String address) throws ServiceException {
        if (!"network".equals(portName)) {
            throw new ServiceException(" Cannot set Endpoint Address for Unknown Port" + portName);
        }
        this.setnetworkEndpointAddress(address);
    }

    public void setEndpointAddress(QName portName, String address) throws ServiceException {
        this.setEndpointAddress(portName.getLocalPart(), address);
    }
}

