
package com.google.api.ads.dfp.jaxws.v201208;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for the creation and management of {@link CustomField} objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "CustomFieldServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface CustomFieldServiceInterface {


    /**
     * 
     *         Creates a new {@link CustomField}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CustomField#name}</li>
     *         <li>{@link CustomField#entityType}</li>
     *         <li>{@link CustomField#dataType}</li>
     *         <li>{@link CustomField#visibility}</li>
     *         </ul>
     *         
     *         @param customField the custom field to create
     *         @return the custom field with its ID filled in
     *       
     * 
     * @param customField
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomField
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createCustomField", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomField")
    @ResponseWrapper(localName = "createCustomFieldResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldResponse")
    public CustomField createCustomField(
        @WebParam(name = "customField", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        CustomField customField)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates a new {@link CustomFieldOption}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CustomFieldOption#displayName}</li>
     *         <li>{@link CustomFieldOption#customFieldId}</li>
     *         </ul>
     *         
     *         @param customFieldOption the custom field to create
     *         @return the custom field option with its ID filled in
     *       
     * 
     * @param customFieldOption
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomFieldOption
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createCustomFieldOption", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldOption")
    @ResponseWrapper(localName = "createCustomFieldOptionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldOptionResponse")
    public CustomFieldOption createCustomFieldOption(
        @WebParam(name = "customFieldOption", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        CustomFieldOption customFieldOption)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link CustomFieldOption} objects.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CustomFieldOption#displayName}</li>
     *         <li>{@link CustomFieldOption#customFieldId}</li>
     *         </ul>
     *         
     *         @param customFieldOptions the custom fields to create
     *         @return the created custom field options with their IDs filled in
     *       
     * 
     * @param customFieldOptions
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.CustomFieldOption>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createCustomFieldOptions", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldOptions")
    @ResponseWrapper(localName = "createCustomFieldOptionsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldOptionsResponse")
    public List<CustomFieldOption> createCustomFieldOptions(
        @WebParam(name = "customFieldOptions", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<CustomFieldOption> customFieldOptions)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link CustomField} objects.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CustomField#name}</li>
     *         <li>{@link CustomField#entityType}</li>
     *         <li>{@link CustomField#dataType}</li>
     *         <li>{@link CustomField#visibility}</li>
     *         </ul>
     *         
     *         @param customFields the custom fields to create
     *         @return the created custom fields with their IDs filled in
     *       
     * 
     * @param customFields
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.CustomField>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createCustomFields", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFields")
    @ResponseWrapper(localName = "createCustomFieldsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacecreateCustomFieldsResponse")
    public List<CustomField> createCustomFields(
        @WebParam(name = "customFields", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<CustomField> customFields)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link CustomField} uniquely identified by the given ID.
     *         
     *         @param customFieldId the ID of the custom field, which must already exist
     *         @return the {@code CustomField} uniquely identified by the given ID
     *       
     * 
     * @param customFieldId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomField
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "getCustomField", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomField")
    @ResponseWrapper(localName = "getCustomFieldResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomFieldResponse")
    public CustomField getCustomField(
        @WebParam(name = "customFieldId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Long customFieldId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link CustomFieldOption} uniquely identified by the given ID.
     *         
     *         @param customFieldOptionId the ID of the custom field option, which must already exist
     *         @return the {@code CustomFieldOption} uniquely identified by the given ID
     *       
     * 
     * @param customFieldOptionId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomFieldOption
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "getCustomFieldOption", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomFieldOption")
    @ResponseWrapper(localName = "getCustomFieldOptionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomFieldOptionResponse")
    public CustomFieldOption getCustomFieldOption(
        @WebParam(name = "customFieldOptionId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Long customFieldOptionId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link CustomFieldPage} of {@link CustomField} objects that satisfy the
     *         given {@link Statement#query}.
     *         The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link CustomField#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code entityType}</td>
     *         <td>{@link CustomField#entityType}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link CustomField#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code isActive}</td>
     *         <td>{@link CustomField#isActive}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code visibility}</td>
     *         <td>{@link CustomField#visibility}</td>
     *         </tr>
     *         </table>
     *         
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of custom fields.
     *         @return the custom fields that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomFieldPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "getCustomFieldsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomFieldsByStatement")
    @ResponseWrapper(localName = "getCustomFieldsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfacegetCustomFieldsByStatementResponse")
    public CustomFieldPage getCustomFieldsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link CustomField} objects that match the given
     *         {@link Statement#query}.
     *         
     *         @param customFieldAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of custom fields
     *         @return the result of the action performed
     *       
     * 
     * @param customFieldAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "performCustomFieldAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceperformCustomFieldAction")
    @ResponseWrapper(localName = "performCustomFieldActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceperformCustomFieldActionResponse")
    public UpdateResult performCustomFieldAction(
        @WebParam(name = "customFieldAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        CustomFieldAction customFieldAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link CustomField}.
     *         
     *         @param customField the custom field to update
     *         @return the updated customField
     *       
     * 
     * @param customField
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomField
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateCustomField", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomField")
    @ResponseWrapper(localName = "updateCustomFieldResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldResponse")
    public CustomField updateCustomField(
        @WebParam(name = "customField", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        CustomField customField)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link CustomFieldOption}.
     *         
     *         @param customFieldOption the custom field option to update
     *         @return the updated customFieldOption
     *       
     * 
     * @param customFieldOption
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.CustomFieldOption
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateCustomFieldOption", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldOption")
    @ResponseWrapper(localName = "updateCustomFieldOptionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldOptionResponse")
    public CustomFieldOption updateCustomFieldOption(
        @WebParam(name = "customFieldOption", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        CustomFieldOption customFieldOption)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link CustomFieldOption} objects.
     *         
     *         @param customFieldOptions the custom field options to update
     *         @return the updated custom field options
     *       
     * 
     * @param customFieldOptions
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.CustomFieldOption>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateCustomFieldOptions", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldOptions")
    @ResponseWrapper(localName = "updateCustomFieldOptionsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldOptionsResponse")
    public List<CustomFieldOption> updateCustomFieldOptions(
        @WebParam(name = "customFieldOptions", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<CustomFieldOption> customFieldOptions)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link CustomField} objects.
     *         
     *         @param customFields the custom fields to update
     *         @return the updated custom fields
     *       
     * 
     * @param customFields
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.CustomField>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateCustomFields", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFields")
    @ResponseWrapper(localName = "updateCustomFieldsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.CustomFieldServiceInterfaceupdateCustomFieldsResponse")
    public List<CustomField> updateCustomFields(
        @WebParam(name = "customFields", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<CustomField> customFields)
        throws ApiException_Exception
    ;

}
