
package com.google.api.ads.dfp.jaxws.v201302;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for creating, updating and retrieving {@link Activity} objects.
 *       <p>
 *       An activity group contains {@link Activity} objects. Activities have a one-to-one relationship
 *       with activity groups. Each activity can belong to only one activity group. Activity groups,
 *       however, have a one-to-many relationship with activities, meaning each activity group can have
 *       multiple activities. A activity group can be used to manage the activities it contains.
 *       </p>
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ActivityServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface ActivityServiceInterface {


    /**
     * 
     *         Creates a new {@link Activity} objects.
     *         
     *         @param activities to be created.
     *         @return the created activities with its IDs filled in.
     *       
     * 
     * @param activities
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201302.Activity>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "createActivities", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacecreateActivities")
    @ResponseWrapper(localName = "createActivitiesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacecreateActivitiesResponse")
    public List<Activity> createActivities(
        @WebParam(name = "activities", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        List<Activity> activities)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates a new {@link Activity}.
     *         
     *         @param activity to be created
     *         @return the created activity with its ID filled in.
     *       
     * 
     * @param activity
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201302.Activity
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "createActivity", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacecreateActivity")
    @ResponseWrapper(localName = "createActivityResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacecreateActivityResponse")
    public Activity createActivity(
        @WebParam(name = "activity", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        Activity activity)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets an {@link ActivityPage} of {@link Activity} objects that satisfy the given
     *         {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link Activity#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link Activity#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code expectedURL}</td>
     *         <td>{@link Activity#expectedURL}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link Activity#status}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code activityGroupId}</td>
     *         <td>{@link Activity#activityGroupId}</td>
     *         </tr>
     *         </table>
     *         
     *         <p><strong>Note:</strong> {@code activityGroupId} is required in the statement.
     *         
     *         @param filterStatement a statement used to filter a set of activities.
     *         @return the activities that match the given filter.
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201302.ActivityPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "getActivitiesByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacegetActivitiesByStatement")
    @ResponseWrapper(localName = "getActivitiesByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacegetActivitiesByStatementResponse")
    public ActivityPage getActivitiesByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link Activity} uniquely identified by the given ID.
     *         
     *         @param activityId the ID of the activity, which must already exist
     *         @return the {@code Activity} uniquely identified by the given ID
     *       
     * 
     * @param activityId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201302.Activity
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "getActivity", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacegetActivity")
    @ResponseWrapper(localName = "getActivityResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfacegetActivityResponse")
    public Activity getActivity(
        @WebParam(name = "activityId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        Integer activityId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Activity} objects.
     *         
     *         @param activities to be updated.
     *         @return the updated activities.
     *       
     * 
     * @param activities
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201302.Activity>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "updateActivities", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfaceupdateActivities")
    @ResponseWrapper(localName = "updateActivitiesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfaceupdateActivitiesResponse")
    public List<Activity> updateActivities(
        @WebParam(name = "activities", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        List<Activity> activities)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Activity}.
     *         
     *         @param activity to be updated.
     *         @return the updated activity.
     *       
     * 
     * @param activity
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201302.Activity
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
    @RequestWrapper(localName = "updateActivity", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfaceupdateActivity")
    @ResponseWrapper(localName = "updateActivityResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302", className = "com.google.api.ads.dfp.jaxws.v201302.ActivityServiceInterfaceupdateActivityResponse")
    public Activity updateActivity(
        @WebParam(name = "activity", targetNamespace = "https://www.google.com/apis/ads/publisher/v201302")
        Activity activity)
        throws ApiException_Exception
    ;

}
