
package com.google.api.ads.dfp.jaxws.v201302;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for OrderError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="OrderError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="UPDATE_CANCELED_ORDER_NOT_ALLOWED"/>
 *     &lt;enumeration value="UPDATE_PENDING_APPROVAL_ORDER_NOT_ALLOWED"/>
 *     &lt;enumeration value="UPDATE_ARCHIVED_ORDER_NOT_ALLOWED"/>
 *     &lt;enumeration value="CANNOT_MODIFY_PROPOSAL_ID"/>
 *     &lt;enumeration value="PRIMARY_USER_REQUIRED"/>
 *     &lt;enumeration value="PRIMARY_USER_CANNOT_BE_SECONDARY"/>
 *     &lt;enumeration value="UNKNOWN"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "OrderError.Reason")
@XmlEnum
public enum OrderErrorReason {


    /**
     * 
     *                 Updating a canceled order is not allowed.
     *               
     * 
     */
    UPDATE_CANCELED_ORDER_NOT_ALLOWED,

    /**
     * 
     *                 Updating an order that has its approval pending is not allowed.
     *               
     * 
     */
    UPDATE_PENDING_APPROVAL_ORDER_NOT_ALLOWED,

    /**
     * 
     *                 Updating an archived order is not allowed.
     *               
     * 
     */
    UPDATE_ARCHIVED_ORDER_NOT_ALLOWED,

    /**
     * 
     *                 DSM can set the proposal ID only at the time of creation of order.
     *                 Setting or changing proposal ID at the time of order update is not
     *                 allowed.
     *               
     * 
     */
    CANNOT_MODIFY_PROPOSAL_ID,

    /**
     * 
     *                 Cannot have secondary user without a primary user.
     *               
     * 
     */
    PRIMARY_USER_REQUIRED,

    /**
     * 
     *                 Primary user cannot be added as a secondary user too.
     *               
     * 
     */
    PRIMARY_USER_CANNOT_BE_SECONDARY,

    /**
     * 
     *                 The value returned if the actual value is not exposed by the requested API version.
     *               
     * 
     */
    UNKNOWN;

    public String value() {
        return name();
    }

    public static OrderErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
