
package com.google.api.ads.dfp.jaxws.v201306;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for creating, updating and retrieving {@link ContentBundle} objects.
 *       
 *       <p>A {@code ContentBundle} is a grouping of {@link Content} that match filter rules as well as
 *       taking into account explicitly included or excluded {@code Content}.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ContentBundleServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface ContentBundleServiceInterface {


    /**
     * 
     *         Creates a new {@link ContentBundle}.
     *         
     *         These fields are required:
     *         <ul>
     *         <li>{@link ContentBundle#name}</li>
     *         <li>{@link ContentBundle#description}<li>
     *         </ul>
     *         
     *         @param contentBundle the content bundle to create
     *         @return the content bundle with its ID filled in
     *       
     * 
     * @param contentBundle
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.ContentBundle
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "createContentBundle", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacecreateContentBundle")
    @ResponseWrapper(localName = "createContentBundleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacecreateContentBundleResponse")
    public ContentBundle createContentBundle(
        @WebParam(name = "contentBundle", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        ContentBundle contentBundle)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link ContentBundle} objects.
     *         
     *         @param contentBundles the content bundles to create
     *         @return the created content bundles with their IDs filled in
     *       
     * 
     * @param contentBundles
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201306.ContentBundle>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "createContentBundles", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacecreateContentBundles")
    @ResponseWrapper(localName = "createContentBundlesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacecreateContentBundlesResponse")
    public List<ContentBundle> createContentBundles(
        @WebParam(name = "contentBundles", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        List<ContentBundle> contentBundles)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link ContentBundle} uniquely identified by the given ID.
     *         
     *         @param contentBundleId the ID of the content bundle, which must already exist
     *         @return the {@code ContentBundle} uniquely identified by the given ID
     *         @throws ApiException if there were errors, such as invalid ID
     *       
     * 
     * @param contentBundleId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.ContentBundle
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "getContentBundle", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacegetContentBundle")
    @ResponseWrapper(localName = "getContentBundleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacegetContentBundleResponse")
    public ContentBundle getContentBundle(
        @WebParam(name = "contentBundleId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Long contentBundleId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link ContentBundlePage} of {@link ContentBundle} objects that satisfy the
     *         given {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link ContentBundle#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link ContentBundle#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link ContentBundle#status}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of content bundles
     *         @return the content bundles that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.ContentBundlePage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "getContentBundlesByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacegetContentBundlesByStatement")
    @ResponseWrapper(localName = "getContentBundlesByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfacegetContentBundlesByStatementResponse")
    public ContentBundlePage getContentBundlesByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link ContentBundle} objects that match the given
     *         {@link Statement#query}.
     *         
     *         @param contentBundleAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of content bundles
     *         @return the result of the action performed
     *       
     * 
     * @param filterStatement
     * @param contentBundleAction
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "performContentBundleAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceperformContentBundleAction")
    @ResponseWrapper(localName = "performContentBundleActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceperformContentBundleActionResponse")
    public UpdateResult performContentBundleAction(
        @WebParam(name = "contentBundleAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        ContentBundleAction contentBundleAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link ContentBundle}.
     *         
     *         @param contentBundle the content bundle to update
     *         @return the updated content bundle
     *       
     * 
     * @param contentBundle
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.ContentBundle
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "updateContentBundle", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceupdateContentBundle")
    @ResponseWrapper(localName = "updateContentBundleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceupdateContentBundleResponse")
    public ContentBundle updateContentBundle(
        @WebParam(name = "contentBundle", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        ContentBundle contentBundle)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link ContentBundle} objects.
     *         
     *         @param contentBundles the content bundles to update
     *         @return the updated content bundles
     *       
     * 
     * @param contentBundles
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201306.ContentBundle>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "updateContentBundles", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceupdateContentBundles")
    @ResponseWrapper(localName = "updateContentBundlesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.ContentBundleServiceInterfaceupdateContentBundlesResponse")
    public List<ContentBundle> updateContentBundles(
        @WebParam(name = "contentBundles", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        List<ContentBundle> contentBundles)
        throws ApiException_Exception
    ;

}
