
package com.google.api.ads.dfp.jaxws.v201306;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for the creation and management of creative wrappers.
 *       {@link CreativeWrapper CreativeWrappers} allow HTML snippets to be
 *       served along with creatives.
 *       <p>
 *       Creative wrappers must be associated with a
 *       {@link LabelType#CREATIVE_WRAPPER} label and applied to ad units by
 *       {@link AdUnit#appliedLabels}.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "CreativeWrapperServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface CreativeWrapperServiceInterface {


    /**
     * 
     *         Creates a new {@code CreativeWrapper}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CreativeWrapper#labelId}</li>
     *         <li>{@link CreativeWrapper#ordering}</li>
     *         <li>{@link CreativeWrapper#header} or {@link CreativeWrapper#footer}</li>
     *         </ul>
     *         
     *         @param creativeWrapper the creative wrapper to create
     *         @return the creative wrapper with its ID filled in
     *         @throws ApiException
     *       
     * 
     * @param creativeWrapper
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.CreativeWrapper
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "createCreativeWrapper", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacecreateCreativeWrapper")
    @ResponseWrapper(localName = "createCreativeWrapperResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacecreateCreativeWrapperResponse")
    public CreativeWrapper createCreativeWrapper(
        @WebParam(name = "creativeWrapper", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        CreativeWrapper creativeWrapper)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates a new {@code CreativeWrapper} objects.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link CreativeWrapper#labelId}</li>
     *         <li>{@link CreativeWrapper#ordering}</li>
     *         <li>{@link CreativeWrapper#header} or {@link CreativeWrapper#footer}</li>
     *         </ul>
     *         
     *         @param creativeWrappers the creative wrappers to create
     *         @return the creative wrappers with their IDs filled in
     *         @throws ApiException
     *       
     * 
     * @param creativeWrappers
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201306.CreativeWrapper>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "createCreativeWrappers", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacecreateCreativeWrappers")
    @ResponseWrapper(localName = "createCreativeWrappersResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacecreateCreativeWrappersResponse")
    public List<CreativeWrapper> createCreativeWrappers(
        @WebParam(name = "creativeWrappers", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        List<CreativeWrapper> creativeWrappers)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link CreativeWrapper} uniquely identified by the given
     *         ID.
     *         
     *         @param creativeWrapperId the ID of the creative wrapper, which
     *         must already exist
     *         @return the {@code CreativeWrapper} uniquely identified by the given
     *         ID
     *         @throws ApiException
     *       
     * 
     * @param creativeWrapperId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.CreativeWrapper
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "getCreativeWrapper", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacegetCreativeWrapper")
    @ResponseWrapper(localName = "getCreativeWrapperResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacegetCreativeWrapperResponse")
    public CreativeWrapper getCreativeWrapper(
        @WebParam(name = "creativeWrapperId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Long creativeWrapperId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link CreativeWrapperPage} of {@link CreativeWrapper}
     *         objects that satisfy the given {@link Statement#query}. The following
     *         fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link CreativeWrapper#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code labelId}</td>
     *         <td>{@link CreativeWrapper#labelId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link CreativeWrapper#status}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code ordering}</td>
     *         <td>{@link CreativeWrapper#ordering}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of creative wrappers.
     *         @return the creative wrappers that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "getCreativeWrappersByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacegetCreativeWrappersByStatement")
    @ResponseWrapper(localName = "getCreativeWrappersByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfacegetCreativeWrappersByStatementResponse")
    public CreativeWrapperPage getCreativeWrappersByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link CreativeWrapper} objects that match the
     *         given {@link Statement#query}.
     *         
     *         @param creativeWrapperAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of labels
     *         @return the result of the action performed
     *       
     * 
     * @param creativeWrapperAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "performCreativeWrapperAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceperformCreativeWrapperAction")
    @ResponseWrapper(localName = "performCreativeWrapperActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceperformCreativeWrapperActionResponse")
    public UpdateResult performCreativeWrapperAction(
        @WebParam(name = "creativeWrapperAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        CreativeWrapperAction creativeWrapperAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@code CreativeWrapper}.
     *         
     *         @param creativeWrapper the creative wrapper to update
     *         @return the updated creative wrapper
     *         @throws ApiException
     *       
     * 
     * @param creativeWrapper
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201306.CreativeWrapper
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "updateCreativeWrapper", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceupdateCreativeWrapper")
    @ResponseWrapper(localName = "updateCreativeWrapperResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceupdateCreativeWrapperResponse")
    public CreativeWrapper updateCreativeWrapper(
        @WebParam(name = "creativeWrapper", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        CreativeWrapper creativeWrapper)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@code CreativeWrapper} objects.
     *         
     *         @param creativeWrappers the creative wrappers to update
     *         @return the updated creative wrapper objects
     *         @throws ApiException
     *       
     * 
     * @param creativeWrappers
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201306.CreativeWrapper>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
    @RequestWrapper(localName = "updateCreativeWrappers", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceupdateCreativeWrappers")
    @ResponseWrapper(localName = "updateCreativeWrappersResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306", className = "com.google.api.ads.dfp.jaxws.v201306.CreativeWrapperServiceInterfaceupdateCreativeWrappersResponse")
    public List<CreativeWrapper> updateCreativeWrappers(
        @WebParam(name = "creativeWrappers", targetNamespace = "https://www.google.com/apis/ads/publisher/v201306")
        List<CreativeWrapper> creativeWrappers)
        throws ApiException_Exception
    ;

}
