
package com.google.api.ads.dfp.jaxws.v201308;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for creating, updating and retrieving {@link AdRule} objects.
 *       
 *       <p>Ad rules contain data that the ad server uses to generate a playlist of
 *       video ads.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "AdRuleServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface AdRuleServiceInterface {


    /**
     * 
     *         Creates a new {@link AdRule}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link AdRule#id}</li>
     *         <li>{@link AdRule#name}</li>
     *         <li>{@link AdRule#priority}</li>
     *         <li>{@link AdRule#startDateTime}</li>
     *         <li>{@link AdRule#endDateTime}</li>
     *         <li>{@link AdRule#preroll}</li>
     *         <li>{@link AdRule#midroll}</li>
     *         <li>{@link AdRule#postroll}</li>
     *         </ul>
     *         
     *         @param adRule the ad rule to create
     *         @return the ad rule with its ID filled in
     *         @throws ApiException if there the ad rule is invalid or there is another
     *         error
     *       
     * 
     * @param adRule
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.AdRule
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createAdRule", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacecreateAdRule")
    @ResponseWrapper(localName = "createAdRuleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacecreateAdRuleResponse")
    public AdRule createAdRule(
        @WebParam(name = "adRule", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        AdRule adRule)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link AdRule} objects.
     *         
     *         @param adRules the ad rules to create
     *         @return the created ad rules with their IDs filled in
     *       
     * 
     * @param adRules
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.AdRule>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createAdRules", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacecreateAdRules")
    @ResponseWrapper(localName = "createAdRulesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacecreateAdRulesResponse")
    public List<AdRule> createAdRules(
        @WebParam(name = "adRules", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<AdRule> adRules)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link AdRule} uniquely identified by the given ID.
     *         
     *         @param adRuleId the ID of the ad rule, which must already exist
     *         @return the {@code AdRule} uniquely identified by the given ID
     *         @throws ApiException if there is an error retrieving the ad rule
     *         or the ID is invalid
     *       
     * 
     * @param adRuleId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.AdRule
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getAdRule", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacegetAdRule")
    @ResponseWrapper(localName = "getAdRuleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacegetAdRuleResponse")
    public AdRule getAdRule(
        @WebParam(name = "adRuleId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Integer adRuleId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets an {@link AdRulePage} of {@link AdRule} objects that satisfy the given
     *         {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link AdRule#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link AdRule#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code priority}</td>
     *         <td>{@link AdRule#priority}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link AdRule#status}</td>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of ad rules
     *         @return the ad rules that match the given filter
     *         @throws ApiException if the ID of the active network does not exist or
     *         there is a backend error
     *       
     * 
     * @param statement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.AdRulePage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getAdRulesByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacegetAdRulesByStatement")
    @ResponseWrapper(localName = "getAdRulesByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfacegetAdRulesByStatementResponse")
    public AdRulePage getAdRulesByStatement(
        @WebParam(name = "statement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement statement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link AdRule} objects that match the given
     *         {@link Statement#query}.
     *         
     *         @param adRuleAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of ad rules
     *         @return the result of the action performed
     *       
     * 
     * @param adRuleAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "performAdRuleAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceperformAdRuleAction")
    @ResponseWrapper(localName = "performAdRuleActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceperformAdRuleActionResponse")
    public UpdateResult performAdRuleAction(
        @WebParam(name = "adRuleAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        AdRuleAction adRuleAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates a previously-created {@link AdRule}.
     *         
     *         @param adRule the ad rule that should be updated
     *         @return the updated ad rule
     *         @throws ApiException if there is an error updating the ad rule
     *       
     * 
     * @param adRule
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.AdRule
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateAdRule", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceupdateAdRule")
    @ResponseWrapper(localName = "updateAdRuleResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceupdateAdRuleResponse")
    public AdRule updateAdRule(
        @WebParam(name = "adRule", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        AdRule adRule)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link AdRule} objects.
     *         
     *         @param adRules the ad rules to update
     *         @return the updated ad rules
     *         @throws ApiException if there is an error updating the ad rules
     *       
     * 
     * @param adRules
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.AdRule>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateAdRules", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceupdateAdRules")
    @ResponseWrapper(localName = "updateAdRulesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.AdRuleServiceInterfaceupdateAdRulesResponse")
    public List<AdRule> updateAdRules(
        @WebParam(name = "adRules", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<AdRule> adRules)
        throws ApiException_Exception
    ;

}
