
package com.google.api.ads.dfp.jaxws.v201308;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for adding, updating and retrieving {@link Proposal} objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ProposalServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface ProposalServiceInterface {


    /**
     * 
     *         Creates a new {@link Proposal}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link Proposal#name}</li>
     *         </ul>
     *         
     *         @param proposal the proposal to create
     *         @return the created proposal with its ID filled in
     *       
     * 
     * @param proposal
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.Proposal
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createProposal", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacecreateProposal")
    @ResponseWrapper(localName = "createProposalResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacecreateProposalResponse")
    public Proposal createProposal(
        @WebParam(name = "proposal", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Proposal proposal)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link Proposal} objects.
     *         
     *         For each proposal, the following fields are required:
     *         <ul>
     *         <li>{@link Proposal#name}</li>
     *         </ul>
     *         
     *         @param proposals the proposals to create
     *         @return the created proposals with their IDs filled in
     *       
     * 
     * @param proposals
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.Proposal>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createProposals", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacecreateProposals")
    @ResponseWrapper(localName = "createProposalsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacecreateProposalsResponse")
    public List<Proposal> createProposals(
        @WebParam(name = "proposals", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<Proposal> proposals)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link Proposal} uniquely identified by the given ID.
     *         
     *         @param proposalId the ID of the proposal, which must already exist
     *         @return the proposal uniquely identified by the given ID
     *       
     * 
     * @param proposalId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.Proposal
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getProposal", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacegetProposal")
    @ResponseWrapper(localName = "getProposalResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacegetProposalResponse")
    public Proposal getProposal(
        @WebParam(name = "proposalId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Long proposalId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link ProposalPage} of {@link Proposal} objects that satisfy the given
     *         {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th>
     *         <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link Proposal#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link Proposal#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link Proposal#status}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code isArchived}</td>
     *         <td>{@link Proposal#isArchived}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code approvalStatus}</td>
     *         <td>{@link Proposal#approvalStatus}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of proposals
     *         @return the proposals that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.ProposalPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getProposalsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacegetProposalsByStatement")
    @ResponseWrapper(localName = "getProposalsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfacegetProposalsByStatementResponse")
    public ProposalPage getProposalsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link Proposal} objects that match the given {@link Statement#query}.
     *         
     *         The following fields are also required when submitting proposals for approval:
     *         <ul>
     *         <li>{@link Proposal#advertiser}</li>
     *         <li>{@link Proposal#primarySalesperson}</li>
     *         <li>{@link Proposal#primaryTraffickerId}</li>
     *         </ul>
     *         
     *         @param proposalAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter a set of proposals
     *         @return the result of the action performed
     *       
     * 
     * @param proposalAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "performProposalAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceperformProposalAction")
    @ResponseWrapper(localName = "performProposalActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceperformProposalActionResponse")
    public UpdateResult performProposalAction(
        @WebParam(name = "proposalAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        ProposalAction proposalAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Proposal}.
     *         
     *         @param proposal the proposal to update
     *         @return the updated proposal
     *       
     * 
     * @param proposal
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.Proposal
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateProposal", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceupdateProposal")
    @ResponseWrapper(localName = "updateProposalResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceupdateProposalResponse")
    public Proposal updateProposal(
        @WebParam(name = "proposal", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Proposal proposal)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Proposal} objects.
     *         
     *         @param proposals the proposals to update
     *         @return the updated proposals
     *       
     * 
     * @param proposals
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.Proposal>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateProposals", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceupdateProposals")
    @ResponseWrapper(localName = "updateProposalsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.ProposalServiceInterfaceupdateProposalsResponse")
    public List<Proposal> updateProposals(
        @WebParam(name = "proposals", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<Proposal> proposals)
        throws ApiException_Exception
    ;

}
