
package com.google.api.ads.dfp.jaxws.v201308;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for managing {@link RateCardCustomization} objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.4-b01
 * Generated source version: 2.1
 * 
 */
@WebService(name = "RateCardCustomizationServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface RateCardCustomizationServiceInterface {


    /**
     * 
     *         Creates a new {@link RateCardCustomization} object.
     *         
     *         @param rateCardCustomization the {@link RateCardCustomization} to be
     *         created
     *         @return the {@link RateCardCustomization} with its ID filled in
     *       
     * 
     * @param rateCardCustomization
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.RateCardCustomization
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createRateCardCustomization", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacecreateRateCardCustomization")
    @ResponseWrapper(localName = "createRateCardCustomizationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacecreateRateCardCustomizationResponse")
    public RateCardCustomization createRateCardCustomization(
        @WebParam(name = "rateCardCustomization", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        RateCardCustomization rateCardCustomization)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates a list of new {@link RateCardCustomization} objects.
     *         
     *         @param rateCardCustomizations the rate card customizations to be created
     *         @return the rate card customizations with their IDs filled in
     *       
     * 
     * @param rateCardCustomizations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.RateCardCustomization>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "createRateCardCustomizations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacecreateRateCardCustomizations")
    @ResponseWrapper(localName = "createRateCardCustomizationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacecreateRateCardCustomizationsResponse")
    public List<RateCardCustomization> createRateCardCustomizations(
        @WebParam(name = "rateCardCustomizations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<RateCardCustomization> rateCardCustomizations)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link RateCardCustomization} object uniquely identified by the
     *         given ID.
     *         
     *         @param rateCardCustomizationId the ID of the rate card customization, which
     *         must already exist.
     *       
     * 
     * @param rateCardCustomizationId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.RateCardCustomization
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getRateCardCustomization", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacegetRateCardCustomization")
    @ResponseWrapper(localName = "getRateCardCustomizationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacegetRateCardCustomizationResponse")
    public RateCardCustomization getRateCardCustomization(
        @WebParam(name = "rateCardCustomizationId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Long rateCardCustomizationId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link RateCardCustomizationPage} of {@link RateCardCustomization}
     *         objects that satisfy the given {@link Statement#query}.
     *         
     *         The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th>
     *         <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code rateCardId}</td>
     *         <td>{@link RateCardCustomization#rateCardId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link RateCardCustomization#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link RateCardCustomization#status}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of rate card customizations.
     *         @return the rate card customizations that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "getRateCardCustomizationsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacegetRateCardCustomizationsByStatement")
    @ResponseWrapper(localName = "getRateCardCustomizationsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfacegetRateCardCustomizationsByStatementResponse")
    public RateCardCustomizationPage getRateCardCustomizationsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link RateCardCustomization} objects that satisfy the
     *         given {@link Statement#query}.
     *         
     *         @param rateCardCustomizationAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of rate card customizations.
     *         @return the result of the action performed
     *       
     * 
     * @param rateCardCustomizationAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "performRateCardCustomizationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceperformRateCardCustomizationAction")
    @ResponseWrapper(localName = "performRateCardCustomizationActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceperformRateCardCustomizationActionResponse")
    public UpdateResult performRateCardCustomizationAction(
        @WebParam(name = "rateCardCustomizationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        RateCardCustomizationAction rateCardCustomizationAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link RateCardCustomization} object.
     *         
     *         @param rateCardCustomization the rate card customization to be updated
     *         @return the updated rate card customization
     *       
     * 
     * @param rateCardCustomization
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201308.RateCardCustomization
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateRateCardCustomization", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceupdateRateCardCustomization")
    @ResponseWrapper(localName = "updateRateCardCustomizationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceupdateRateCardCustomizationResponse")
    public RateCardCustomization updateRateCardCustomization(
        @WebParam(name = "rateCardCustomization", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        RateCardCustomization rateCardCustomization)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link RateCardCustomization} objects.
     *         
     *         @param rateCardCustomizations the rate card customizations to be updated
     *         @return the updated rate card customizations
     *       
     * 
     * @param rateCardCustomizations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201308.RateCardCustomization>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
    @RequestWrapper(localName = "updateRateCardCustomizations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceupdateRateCardCustomizations")
    @ResponseWrapper(localName = "updateRateCardCustomizationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308", className = "com.google.api.ads.dfp.jaxws.v201308.RateCardCustomizationServiceInterfaceupdateRateCardCustomizationsResponse")
    public List<RateCardCustomization> updateRateCardCustomizations(
        @WebParam(name = "rateCardCustomizations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201308")
        List<RateCardCustomization> rateCardCustomizations)
        throws ApiException_Exception
    ;

}
