
package com.google.api.ads.dfp.jaxws.v201111;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CompanyCreditStatusError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="CompanyCreditStatusError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="COMPANY_CREDIT_STATUS_CHANGE_NOT_ALLOWED"/>
 *     &lt;enumeration value="CANNOT_USE_CREDIT_STATUS_SETTING"/>
 *     &lt;enumeration value="CANNOT_USE_ADVANCED_CREDIT_STATUS_SETTING"/>
 *     &lt;enumeration value="UNACCEPTABLE_COMPANY_CREDIT_STATUS_FOR_ORDER"/>
 *     &lt;enumeration value="UNACCEPTABLE_COMPANY_CREDIT_STATUS_FOR_LINE_ITEM"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "CompanyCreditStatusError.Reason")
@XmlEnum
public enum CompanyCreditStatusErrorReason {


    /**
     * 
     *                 The user's role does not have permission to change
     *                 {@link Company#creditStatus} from the default value. The default value is
     *                 {@link Company.CreditStatus#ACTIVE} for the Basic credit status setting
     *                 and {@link Company.CreditStatus#ON_HOLD} for the Advanced credit status
     *                 setting.
     *               
     * 
     */
    COMPANY_CREDIT_STATUS_CHANGE_NOT_ALLOWED,

    /**
     * 
     *                 The network has not been enabled for editing credit status settings for
     *                 companies.
     *               
     * 
     */
    CANNOT_USE_CREDIT_STATUS_SETTING,

    /**
     * 
     *                 The network has not been enabled for the Advanced credit status
     *                 settings for companies. {@link Company#creditStatus} must be either
     *                 {@code ACTIVE} or {@code INACTIVE}.
     *               
     * 
     */
    CANNOT_USE_ADVANCED_CREDIT_STATUS_SETTING,

    /**
     * 
     *                 An order cannot be created or updated because the
     *                 {@link Order#advertiserId} or the {@link Order#agencyId} it is associated
     *                 with has {@link Company#creditStatus} that is not {@code ACTIVE} or
     *                 {@code ON_HOLD}.
     *               
     * 
     */
    UNACCEPTABLE_COMPANY_CREDIT_STATUS_FOR_ORDER,

    /**
     * 
     *                 A line item cannot be created for the order because the
     *                 {@link Order#advertiserId} or {Order#agencyId} it is associated with has
     *                 {@link Company#creditStatus} that is not {@code ACTIVE} or
     *                 {@code ON_HOLD}.
     *               
     * 
     */
    UNACCEPTABLE_COMPANY_CREDIT_STATUS_FOR_LINE_ITEM;

    public String value() {
        return name();
    }

    public static CompanyCreditStatusErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
