
package com.google.api.ads.dfp.jaxws.v201111;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CreativeError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="CreativeError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="FLASH_AND_FALLBACK_URL_ARE_SAME"/>
 *     &lt;enumeration value="INVALID_INTERNAL_REDIRECT_URL"/>
 *     &lt;enumeration value="DESTINATION_URL_REQUIRED"/>
 *     &lt;enumeration value="CANNOT_CREATE_OR_UPDATE_LEGACY_DFP_CREATIVE"/>
 *     &lt;enumeration value="INVALID_COMPANY_TYPE"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "CreativeError.Reason")
@XmlEnum
public enum CreativeErrorReason {


    /**
     * 
     *                 {@link FlashRedirectCreative#flashUrl} and
     *                 {@link FlashRedirectCreative#fallbackUrl} are the same. The fallback URL
     *                 is used when the flash URL does not work and must be different from it.
     *               
     * 
     */
    FLASH_AND_FALLBACK_URL_ARE_SAME,

    /**
     * 
     *                 The internal redirect URL was invalid. The URL must have the following
     *                 syntax http://ad.doubleclick.net/ad/sitename/;sz=size.
     *               
     * 
     */
    INVALID_INTERNAL_REDIRECT_URL,

    /**
     * 
     *                 {@link HasDestinationUrlCreative#destinationUrl} is required.
     *               
     * 
     */
    DESTINATION_URL_REQUIRED,

    /**
     * 
     *                 Cannot create or update legacy DART For Publishers creative.
     *               
     * 
     */
    CANNOT_CREATE_OR_UPDATE_LEGACY_DFP_CREATIVE,

    /**
     * 
     *                 Company type should be one of Advertisers, House Advertisers and
     *                 Ad Networks.
     *               
     * 
     */
    INVALID_COMPANY_TYPE;

    public String value() {
        return name();
    }

    public static CreativeErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
