
package com.google.api.ads.dfp.jaxws.v201111;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for LineItemOperationError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="LineItemOperationError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="NOT_ALLOWED"/>
 *     &lt;enumeration value="NOT_APPLICABLE"/>
 *     &lt;enumeration value="HAS_COMPLETED"/>
 *     &lt;enumeration value="HAS_NO_ACTIVE_CREATIVES"/>
 *     &lt;enumeration value="CANNOT_ACTIVATE_LEGACY_DFP_LINE_ITEM"/>
 *     &lt;enumeration value="CANNOT_DELETE_DELIVERED_LINE_ITEM"/>
 *     &lt;enumeration value="CANNOT_RESERVE_COMPANY_CREDIT_STATUS_NOT_ACTIVE"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "LineItemOperationError.Reason")
@XmlEnum
public enum LineItemOperationErrorReason {


    /**
     * 
     *                 The operation is not allowed due to lack of permissions.
     *               
     * 
     */
    NOT_ALLOWED,

    /**
     * 
     *                 The operation is not applicable for the current state of the
     *                 {@link LineItem}.
     *               
     * 
     */
    NOT_APPLICABLE,

    /**
     * 
     *                 The {@link LineItem} is completed. A {@link LineItemAction} cannot
     *                 be applied to a line item that is completed.
     *               
     * 
     */
    HAS_COMPLETED,

    /**
     * 
     *                 The {@link LineItem} has no active creatives. A line item cannot be
     *                 activated with no active creatives.
     *               
     * 
     */
    HAS_NO_ACTIVE_CREATIVES,

    /**
     * 
     *                 A {@link LineItem} of type {@link LineItemType#LEGACY_DFP} cannot be
     *                 Activated.
     *               
     * 
     */
    CANNOT_ACTIVATE_LEGACY_DFP_LINE_ITEM,

    /**
     * 
     *                 Deleting an {@link LineItem} that has delivered is not allowed
     *               
     * 
     */
    CANNOT_DELETE_DELIVERED_LINE_ITEM,

    /**
     * 
     *                 Reservation cannot be made for line item because the
     *                 {@link LineItem#advertiserId} it is associated with has
     *                 {@link Company#creditStatus} that is not {@code ACTIVE}.
     *               
     * 
     */
    CANNOT_RESERVE_COMPANY_CREDIT_STATUS_NOT_ACTIVE;

    public String value() {
        return name();
    }

    public static LineItemOperationErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
