
package com.google.api.ads.dfp.jaxws.v201111;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides operations for retrieving information related to the publisher's
 *       networks. This service can be used to obtain the list of all networks
 *       that the current login has access to, or to obtain information about a
 *       specific network.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "NetworkServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface NetworkServiceInterface {


    /**
     * 
     *         Returns the list of {@link Network} objects to which the current login has
     *         access.
     *         <p>
     *         Intended to be used without a network code in the SOAP header when the
     *         login may have more than one network associated with it.
     *         </p>
     *         
     *         @return the networks to which the current login has access
     *       
     * 
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201111.Network>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111")
    @RequestWrapper(localName = "getAllNetworks", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfacegetAllNetworks")
    @ResponseWrapper(localName = "getAllNetworksResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfacegetAllNetworksResponse")
    public List<Network> getAllNetworks()
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the current network for which requests are being made.
     *         
     *         @return the network for which the user is currently making the request
     *       
     * 
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201111.Network
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111")
    @RequestWrapper(localName = "getCurrentNetwork", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfacegetCurrentNetwork")
    @ResponseWrapper(localName = "getCurrentNetworkResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfacegetCurrentNetworkResponse")
    public Network getCurrentNetwork()
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified network. Currently, only the network display name can
     *         be updated.
     *         
     *         @param network the network that needs to be updated
     *         @return the updated network
     *       
     * 
     * @param network
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201111.Network
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111")
    @RequestWrapper(localName = "updateNetwork", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfaceupdateNetwork")
    @ResponseWrapper(localName = "updateNetworkResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111", className = "com.google.api.ads.dfp.jaxws.v201111.NetworkServiceInterfaceupdateNetworkResponse")
    public Network updateNetwork(
        @WebParam(name = "network", targetNamespace = "https://www.google.com/apis/ads/publisher/v201111")
        Network network)
        throws ApiException_Exception
    ;

}
