
package com.google.api.ads.dfp.jaxws.v201111;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for VideoPositionTargetingType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="VideoPositionTargetingType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="PREROLL"/>
 *     &lt;enumeration value="MIDROLL"/>
 *     &lt;enumeration value="POSTROLL"/>
 *     &lt;enumeration value="BUMPER"/>
 *     &lt;enumeration value="PREROLL_BUMPER"/>
 *     &lt;enumeration value="MIDROLL_BUMPER"/>
 *     &lt;enumeration value="POSTROLL_BUMPER"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "VideoPositionTargetingType")
@XmlEnum
public enum VideoPositionTargetingType {


    /**
     * 
     *                 The position defined as showing before the video starts playing.
     *               
     * 
     */
    PREROLL,

    /**
     * 
     *                 The position defined as showing within the middle of the playing video.
     *               
     * 
     */
    MIDROLL,

    /**
     * 
     *                 The position defined as showing after the video is completed.
     *               
     * 
     */
    POSTROLL,

    /**
     * 
     *                 The four positions defined as bumpers; those that appear before and after
     *                 the pre-roll and post-roll positions.
     *               
     * 
     */
    BUMPER,

    /**
     * 
     *                 The two positions defined as those which appear before and after the
     *                 pre-roll position.
     *               
     * 
     */
    PREROLL_BUMPER,

    /**
     * 
     *                 The positions defined as those which appear before and after each of the
     *                 mid-roll positions, within a stream.
     *               
     * 
     */
    MIDROLL_BUMPER,

    /**
     * 
     *                 The two positions defined as those which appear before and after the
     *                 post-roll position.
     *               
     * 
     */
    POSTROLL_BUMPER;

    public String value() {
        return name();
    }

    public static VideoPositionTargetingType fromValue(String v) {
        return valueOf(v);
    }

}
