
package com.google.api.ads.dfp.jaxws.v201201;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for retrieving {@link CreativeTemplate} objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "CreativeTemplateServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface CreativeTemplateServiceInterface {


    /**
     * 
     *         Returns the {@link CreativeTemplate} uniquely identified by the given ID.
     *         
     *         @param creativeTemplateId the ID of the creative template, which must already exist
     *         @return the {@code CreativeTemplate} uniquely identified by the given ID
     *       
     * 
     * @param creativeTemplateId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.CreativeTemplate
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "getCreativeTemplate", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.CreativeTemplateServiceInterfacegetCreativeTemplate")
    @ResponseWrapper(localName = "getCreativeTemplateResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.CreativeTemplateServiceInterfacegetCreativeTemplateResponse")
    public CreativeTemplate getCreativeTemplate(
        @WebParam(name = "creativeTemplateId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        Long creativeTemplateId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link CreativeTemplatePage} of {@link CreativeTemplate} objects that satisfy the
     *         given {@link Statement#query}.  The following fields are supported for
     *         filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link CreativeTemplate#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link CreativeTemplate#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code type}</td>
     *         <td>{@link CreativeTemplate#type}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link CreativeTemplate#status}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of creative templates.
     *         @return the creative templates that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.CreativeTemplatePage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "getCreativeTemplatesByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.CreativeTemplateServiceInterfacegetCreativeTemplatesByStatement")
    @ResponseWrapper(localName = "getCreativeTemplatesByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.CreativeTemplateServiceInterfacegetCreativeTemplatesByStatementResponse")
    public CreativeTemplatePage getCreativeTemplatesByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        Statement filterStatement)
        throws ApiException_Exception
    ;

}
