
package com.google.api.ads.dfp.jaxws.v201201;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for creating, updating and retrieving {@link LineItem}
 *       objects.
 *       
 *       <p>Line items define the campaign. For example, line items define:
 *       <ul>
 *       <li>a budget
 *       <li>a span of time to run
 *       <li>ad unit targeting
 *       </ul>
 *       
 *       <p>In short, line items connect all of the elements of an ad campaign.
 *       
 *       <p>Line items and creatives can be associated with each other through
 *       {@link LineItemCreativeAssociation} objects. An ad unit will host a creative
 *       through both this association and the {@link LineItem#targeting} to it.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "LineItemServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface LineItemServiceInterface {


    /**
     * 
     *         Creates a new {@link LineItem}.
     *         
     *         These fields are required:
     *         <ul>
     *         <li>{@link LineItem#costPerUnit}</li>
     *         <li>{@link LineItem#costType}<li>
     *         <li>{@link LineItem#endDateTime}</li>
     *         <li>{@link LineItem#lineItemType}</li>
     *         <li>{@link LineItem#name}</li>
     *         <li>{@link LineItem#orderId}</li>
     *         <li>{@link LineItem#startDateTime}</li>
     *         <li>{@link LineItem#unitsBought}</li>
     *         <li>{@link LineItem#creativePlaceholders}</li>
     *         <li>{@link LineItem#targeting}</li>
     *         </ul>
     *         
     *         @param lineItem the line item to create
     *         @return the line item with its ID filled in
     *       
     * 
     * @param lineItem
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.LineItem
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "createLineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacecreateLineItem")
    @ResponseWrapper(localName = "createLineItemResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacecreateLineItemResponse")
    public LineItem createLineItem(
        @WebParam(name = "lineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        LineItem lineItem)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link LineItem} objects.
     *         
     *         @param lineItems the line items to create
     *         @return the created line items with their IDs filled in
     *       
     * 
     * @param lineItems
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201201.LineItem>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "createLineItems", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacecreateLineItems")
    @ResponseWrapper(localName = "createLineItemsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacecreateLineItemsResponse")
    public List<LineItem> createLineItems(
        @WebParam(name = "lineItems", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        List<LineItem> lineItems)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link LineItem} uniquely identified by the given ID.
     *         
     *         @param lineItemId the ID of the line item, which must already exist
     *         @return the {@code LineItem} uniquely identified by the given ID
     *       
     * 
     * @param lineItemId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.LineItem
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "getLineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacegetLineItem")
    @ResponseWrapper(localName = "getLineItemResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacegetLineItemResponse")
    public LineItem getLineItem(
        @WebParam(name = "lineItemId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        Long lineItemId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link LineItemPage} of {@link LineItem} objects that satisfy the
     *         given {@link Statement#query}. The following fields are supported for
     *         filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code costType}</td>
     *         <td>{@link LineItem#costType}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link LineItem#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code lineItemType}</td>
     *         <td>{@link LineItem#lineItemType}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link LineItem#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code orderId}</td>
     *         <td>{@link LineItem#orderId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link LineItem#status}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code unitsBought}</td>
     *         <td>{@link LineItem#unitsBought}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code deliveryRateType}</td>
     *         <td>{@link LineItem#deliveryRateType}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code lastModifiedDateTime}</td>
     *         <td>{@link LineItem#lastModifiedDateTime}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of line items.
     *         @return the line items that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.LineItemPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "getLineItemsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacegetLineItemsByStatement")
    @ResponseWrapper(localName = "getLineItemsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfacegetLineItemsByStatementResponse")
    public LineItemPage getLineItemsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link LineItem} objects that match the given
     *         {@link Statement#query}.
     *         
     *         @param lineItemAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of line items
     *         @return the result of the action performed
     *       
     * 
     * @param filterStatement
     * @param lineItemAction
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "performLineItemAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceperformLineItemAction")
    @ResponseWrapper(localName = "performLineItemActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceperformLineItemActionResponse")
    public UpdateResult performLineItemAction(
        @WebParam(name = "lineItemAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        LineItemAction lineItemAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link LineItem}.
     *         
     *         @param lineItem the line item to update
     *         @return the updated line item
     *       
     * 
     * @param lineItem
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201201.LineItem
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "updateLineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceupdateLineItem")
    @ResponseWrapper(localName = "updateLineItemResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceupdateLineItemResponse")
    public LineItem updateLineItem(
        @WebParam(name = "lineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        LineItem lineItem)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link LineItem} objects.
     *         
     *         @param lineItems the line items to update
     *         @return the updated line items
     *       
     * 
     * @param lineItems
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201201.LineItem>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
    @RequestWrapper(localName = "updateLineItems", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceupdateLineItems")
    @ResponseWrapper(localName = "updateLineItemsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201", className = "com.google.api.ads.dfp.jaxws.v201201.LineItemServiceInterfaceupdateLineItemsResponse")
    public List<LineItem> updateLineItems(
        @WebParam(name = "lineItems", targetNamespace = "https://www.google.com/apis/ads/publisher/v201201")
        List<LineItem> lineItems)
        throws ApiException_Exception
    ;

}
