
package com.google.api.ads.dfp.jaxws.v201203;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Column.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Column">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="AD_SERVER_IMPRESSIONS"/>
 *     &lt;enumeration value="AD_SERVER_CLICKS"/>
 *     &lt;enumeration value="AD_SERVER_CTR"/>
 *     &lt;enumeration value="AD_SERVER_REVENUE"/>
 *     &lt;enumeration value="AD_SERVER_AVERAGE_ECPM"/>
 *     &lt;enumeration value="AD_SERVER_PERCENT_IMPRESSIONS"/>
 *     &lt;enumeration value="AD_SERVER_PERCENT_CLICKS"/>
 *     &lt;enumeration value="AD_SERVER_PERCENT_REVENUE"/>
 *     &lt;enumeration value="AD_SERVER_DELIVERY_INDICATOR"/>
 *     &lt;enumeration value="ADSENSE_IMPRESSIONS"/>
 *     &lt;enumeration value="ADSENSE_CLICKS"/>
 *     &lt;enumeration value="ADSENSE_CTR"/>
 *     &lt;enumeration value="ADSENSE_REVENUE"/>
 *     &lt;enumeration value="ADSENSE_AVERAGE_ECPM"/>
 *     &lt;enumeration value="ADSENSE_PERCENT_IMPRESSIONS"/>
 *     &lt;enumeration value="ADSENSE_PERCENT_CLICKS"/>
 *     &lt;enumeration value="ADSENSE_PERCENT_REVENUE"/>
 *     &lt;enumeration value="AD_EXCHANGE_IMPRESSIONS"/>
 *     &lt;enumeration value="AD_EXCHANGE_CLICKS"/>
 *     &lt;enumeration value="AD_EXCHANGE_CTR"/>
 *     &lt;enumeration value="AD_EXCHANGE_REVENUE"/>
 *     &lt;enumeration value="AD_EXCHANGE_AVERAGE_ECPM"/>
 *     &lt;enumeration value="TOTAL_IMPRESSIONS"/>
 *     &lt;enumeration value="TOTAL_CLICKS"/>
 *     &lt;enumeration value="TOTAL_CTR"/>
 *     &lt;enumeration value="TOTAL_REVENUE"/>
 *     &lt;enumeration value="TOTAL_AVERAGE_ECPM"/>
 *     &lt;enumeration value="TOTAL_UNFILLED_IMPRESSIONS"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_DELIVERY_INDICATOR"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_IMPRESSIONS"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_CLICKS"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_CTR"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_REVENUE"/>
 *     &lt;enumeration value="MERGED_AD_SERVER_AVERAGE_ECPM"/>
 *     &lt;enumeration value="OPTIMIZATION_CONTROL_IMPRESSIONS"/>
 *     &lt;enumeration value="OPTIMIZATION_CONTROL_CLICKS"/>
 *     &lt;enumeration value="OPTIMIZATION_CONTROL_CTR"/>
 *     &lt;enumeration value="OPTIMIZATION_OPTIMIZED_IMPRESSIONS"/>
 *     &lt;enumeration value="OPTIMIZATION_OPTIMIZED_CLICKS"/>
 *     &lt;enumeration value="OPTIMIZATION_OPTIMIZED_CTR"/>
 *     &lt;enumeration value="OPTIMIZATION_LIFT"/>
 *     &lt;enumeration value="REACH_FREQUENCY"/>
 *     &lt;enumeration value="REACH_AVERAGE_REVENUE"/>
 *     &lt;enumeration value="REACH"/>
 *     &lt;enumeration value="POST_IMPRESSION_ACTIVITIES"/>
 *     &lt;enumeration value="ACTIVITIES_PER_THOUSAND_IMPRESSIONS"/>
 *     &lt;enumeration value="POST_CLICK_ACTIVITIES"/>
 *     &lt;enumeration value="ACTIVITIES_PER_CLICK"/>
 *     &lt;enumeration value="POST_IMPRESSION_REVENUE"/>
 *     &lt;enumeration value="POST_CLICK_REVENUE"/>
 *     &lt;enumeration value="TOTAL_ACTIVITIES"/>
 *     &lt;enumeration value="TOTAL_ACTIVITY_REVENUE"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Column")
@XmlEnum
public enum Column {


    /**
     * 
     *                 The number of impressions delivered by the ad server.
     *               
     * 
     */
    AD_SERVER_IMPRESSIONS,

    /**
     * 
     *                 The number of clicks delivered by the ad server.
     *               
     * 
     */
    AD_SERVER_CLICKS,

    /**
     * 
     *                 The CTR for an ad delivered by the ad server.
     *               
     * 
     */
    AD_SERVER_CTR,

    /**
     * 
     *                 The revenue earned, calculated in publisher currency, for the ads delivered
     *                 by the ad server.
     *                 <p>
     *                 Replaced with {@code AD_SERVER_CPM_AND_CPC_REVENUE} beginning in v201206.
     *               
     * 
     */
    AD_SERVER_REVENUE,

    /**
     * 
     *                 The average estimated cost-per-thousand-impressions earned from the ads
     *                 delivered by the ad server.
     *               
     * 
     */
    AD_SERVER_AVERAGE_ECPM,

    /**
     * 
     *                 The ratio of the number of impressions delivered by the ad server to the
     *                 total impressions delivered represented as a percentage.
     *                 <p>
     *                 Replaced with {@code AD_SERVER_INVENTORY_LEVEL_PERCENT_IMPRESSIONS} beginning in v201206.
     *               
     * 
     */
    AD_SERVER_PERCENT_IMPRESSIONS,

    /**
     * 
     *                 The ratio of the number of clicks delivered by the ad server to the total
     *                 clicks delivered.
     *                 <p>
     *                 Replaced with {@code AD_SERVER_INVENTORY_LEVEL_PERCENT_CLICKS} beginning in v201206.
     *               
     * 
     */
    AD_SERVER_PERCENT_CLICKS,

    /**
     * 
     *                 The ratio of revenue generated by ad server to the total revenue earned
     *                 expressed as a percentage.
     *                 <p>
     *                 Replaced with {@code AD_SERVER_INVENTORY_LEVEL_PERCENT_REVENUE} beginning in v201206.
     *               
     * 
     */
    AD_SERVER_PERCENT_REVENUE,

    /**
     * 
     *                 Indicates the progress made for the delivery of the {@link LineItem}.
     *                 <table>
     *                 <tr>
     *                 <th scope="col">Progress</th> <th scope="col">Definition</th>
     *                 </tr>
     *                 <tr>
     *                 <td>100%</td>
     *                 <td>The {@link LineItem} is on track to deliver in full as per
     *                 {@link LineItemSummary#unitsBought}.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>&gt; 100%</td>
     *                 <td>The {@link LineItem} is on track to overdeliver.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>&lt; 100%</td>
     *                 <td>The {@link LineItem} is on track to underdeliver.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>N/A</td>
     *                 <td>The {@link LineItem} does not have any quantity goals, or there is
     *                 insufficient information about the {@link LineItem}.</td>
     *                 </tr>
     *                 </table>
     *               
     * 
     */
    AD_SERVER_DELIVERY_INDICATOR,

    /**
     * 
     *                 The number of impressions an AdSense ad delivered when no {@link LineItem}
     *                 reservation could be found by the ad server.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_IMPRESSIONS} beginning in v201206.
     *               
     * 
     */
    ADSENSE_IMPRESSIONS,

    /**
     * 
     *                 The number of clicks an AdSense ad delivered when no {@link LineItem}
     *                 reservation could be found by the ad server.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_CLICKS} beginning in v201206.
     *               
     * 
     */
    ADSENSE_CLICKS,

    /**
     * 
     *                 The ratio of clicks an AdSense ad delivered to the number of impressions
     *                 it delivered.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_CTR} beginning in v201206.
     *               
     * 
     */
    ADSENSE_CTR,

    /**
     * 
     *                 Revenue generated from AdSense ads in publisher currency and time zone.
     *                 <p>
     *                 Replaced with {@code  DYNAMIC_ALLOCATION_INVENTORY_LEVEL_REVENUE} beginning in v201206.
     *               
     * 
     */
    ADSENSE_REVENUE,

    /**
     * 
     *                 The average estimated cost-per-thousand-impressions earned from the ads
     *                 delivered by AdSense.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_AVERAGE_ECPM} beginning in v201206.
     *               
     * 
     */
    ADSENSE_AVERAGE_ECPM,

    /**
     * 
     *                 The ratio of the number of impressions delivered by AdSense to the
     *                 total impressions delivered represented as a percentage.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_PERCENT_IMPRESSIONS}
     *                 beginning in v201206.
     *               
     * 
     */
    ADSENSE_PERCENT_IMPRESSIONS,

    /**
     * 
     *                 The ratio of the number of clicks delivered by AdSense to the total
     *                 clicks delivered.
     *                 <p>
     *                 Replaced with {@code DYNAMIC_ALLOCATION_INVENTORY_LEVEL_PERCENT_CLICKS} beginning in v201206.
     *               
     * 
     */
    ADSENSE_PERCENT_CLICKS,

    /**
     * 
     *                 The ratio of revenue generated by AdSense to the total revenue earned
     *                 expressed as a percentage.
     *                 <p>
     *                 Replaced with {@code  DYNAMIC_ALLOCATION_INVENTORY_LEVEL_PERCENT_REVENUE} beginning in v201206.
     *               
     * 
     */
    ADSENSE_PERCENT_REVENUE,

    /**
     * 
     *                 The number of impressions an Ad Exchange ad delivered.
     *                 <p>
     *                 Replaced with {@code AD_EXCHANGE_LINE_ITEM_LEVEL_IMPRESSIONS} beginning in v201206.
     *               
     * 
     */
    AD_EXCHANGE_IMPRESSIONS,

    /**
     * 
     *                 The number of clicks an Ad Exchange ad delivered.
     *                 <p>
     *                 Replaced with {@code AD_EXCHANGE_LINE_ITEM_LEVEL_CLICKS} beginning in v201206.
     *               
     * 
     */
    AD_EXCHANGE_CLICKS,

    /**
     * 
     *                 The ratio of clicks an Ad Exchange ad delivered to the number of
     *                 impressions it delivered.
     *                 <p>
     *                 Replaced with {@code AD_EXCHANGE_LINE_ITEM_LEVEL_CTR} beginning in v201206.
     *               
     * 
     */
    AD_EXCHANGE_CTR,

    /**
     * 
     *                 Revenue generated from Ad Exchange ads in publisher currency and time zone.
     *                 <p>
     *                 Replaced with {@code AD_EXCHANGE_LINE_ITEM_LEVEL_REVENUE} beginning in v201206.
     *               
     * 
     */
    AD_EXCHANGE_REVENUE,

    /**
     * 
     *                 The average estimated cost-per-thousand-impressions earned from the
     *                 delivery of Ad Exchange ads.
     *                 <p>
     *                 Replaced with {@code AD_EXCHANGE_LINE_ITEM_LEVEL_AVERAGE_ECPM} beginning in v201206.
     *               
     * 
     */
    AD_EXCHANGE_AVERAGE_ECPM,

    /**
     * 
     *                 The total number of impressions delivered by the ad servers.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_IMPRESSIONS} beginning in v201206.
     *               
     * 
     */
    TOTAL_IMPRESSIONS,

    /**
     * 
     *                 The sum total of clicks on ads delivered by the ad servers.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_CLICKS} beginning in v201206.
     *               
     * 
     */
    TOTAL_CLICKS,

    /**
     * 
     *                 The ratio of clicks on ads delivered by the ad servers to the total number
     *                 of impressions delivered for an ad.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_CTR} beginning in v201206.
     *               
     * 
     */
    TOTAL_CTR,

    /**
     * 
     *                 The sum total of the revenue generated by the ad servers.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_CPM_AND_CPC_REVENUE} beginning in v201206.
     *               
     * 
     */
    TOTAL_REVENUE,

    /**
     * 
     *                 Estimated cost-per-thousand-impressions (eCPM) of ads delivered by the ad servers.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_AVERAGE_ECPM} beginning in v201206.
     *               
     * 
     */
    TOTAL_AVERAGE_ECPM,

    /**
     * 
     *                 The total number of missed impressions due to the ad servers' inability to
     *                 find ads to serve.
     *                 <p>
     *                 Replaced with {@code TOTAL_INVENTORY_LEVEL_UNFILLED_IMPRESSIONS} beginning in v201206.
     *               
     * 
     */
    TOTAL_UNFILLED_IMPRESSIONS,

    /**
     * 
     *                 Indicates the progress made for the delivery of the {@link LineItem} based
     *                 on the units delivered by both DART and DoubleClick For Publishers ad
     *                 servers. This is only available for networks that have been upgraded from
     *                 the old to the new system.
     *                 <table>
     *                 <tr>
     *                 <th scope="col">Progress</th> <th scope="col">Definition</th>
     *                 </tr>
     *                 <tr>
     *                 <td>100%</td>
     *                 <td>The {@link LineItem} is on track to deliver in full as per
     *                 {@link LineItemSummary#unitsBought}.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>&gt; 100%</td>
     *                 <td>The {@link LineItem} is on track to overdeliver.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>&lt; 100%</td>
     *                 <td>The {@link LineItem} is on track to underdeliver.</td>
     *                 </tr>
     *                 <tr>
     *                 <td>N/A</td>
     *                 <td>The {@link LineItem} does not have any quantity goals, or there is
     *                 insufficient information about the {@link LineItem}.</td>
     *                 </tr>
     *                 </table>
     *               
     * 
     */
    MERGED_AD_SERVER_DELIVERY_INDICATOR,

    /**
     * 
     *                 The total number of impressions delivered by both DART and DoubleClick For
     *                 Publishers ad servers. This is only available for networks that have been
     *                 upgraded from the old to the new system.
     *               
     * 
     */
    MERGED_AD_SERVER_IMPRESSIONS,

    /**
     * 
     *                 The total number of clicks delivered by both DART and DoubleClick For
     *                 Publishers ad servers. This is only available for networks that
     *                 have been upgraded from the old to the new system.
     *               
     * 
     */
    MERGED_AD_SERVER_CLICKS,

    /**
     * 
     *                 The sum of the CTR achieved from both DART and DoubleClick For Publishers
     *                 ad servers. This is only available for networks that have been upgraded
     *                 from the old to the new system.
     *               
     * 
     */
    MERGED_AD_SERVER_CTR,

    /**
     * 
     *                 The sum of the revenue generated from both DART and DoubleClick For
     *                 Publishers ad servers. This is only available for networks that have been
     *                 upgraded from the old to the new system.
     *                 <p>
     *                 Replaced with {@code MERGED_AD_SERVER_CPM_AND_CPC_REVENUE} beginning in v201206.
     *               
     * 
     */
    MERGED_AD_SERVER_REVENUE,

    /**
     * 
     *                 The sum of the eCPM generated from both DART and DoubleClick For
     *                 Publishers ad servers . This is only available for networks that have been
     *                 upgraded from the old to the new system.
     *               
     * 
     */
    MERGED_AD_SERVER_AVERAGE_ECPM,

    /**
     * 
     *                 The number of control (unoptimized) impressions delivered for an ad for
     *                 which the optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_CONTROL_IMPRESSIONS,

    /**
     * 
     *                 Number of clicks resulting from the delivery of control (unoptimized)
     *                 impressions for an ad for which the optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_CONTROL_CLICKS,

    /**
     * 
     *                 The CTR for control (unoptimized) impressions for an order for which the
     *                 optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_CONTROL_CTR,

    /**
     * 
     *                 Number of optimized impressions delivered for an ad for which the
     *                 optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_OPTIMIZED_IMPRESSIONS,

    /**
     * 
     *                 Number of clicks resulting from the delivery of optimized impressions for
     *                 an ad for which the optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_OPTIMIZED_CLICKS,

    /**
     * 
     *                 The CTR for optimized impressions for an ad for which the optimization
     *                 feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_OPTIMIZED_CTR,

    /**
     * 
     *                 The percentage by which optimized CTRs are greater than the unoptimized
     *                 CTRs. This is calculated as (({@link Column#OPTIMIZATION_OPTIMIZED_CTR}/
     *                 {@link Column#OPTIMIZATION_CONTROL_CTR}) - 1) * 100 for an ad for which the
     *                 optimization feature has been enabled.
     *               
     * 
     */
    OPTIMIZATION_LIFT,

    /**
     * 
     *                 The average number of ads displayed to each unique visitor.
     *               
     * 
     */
    REACH_FREQUENCY,

    /**
     * 
     *                 The average revenue earned per unique visitor.
     *               
     * 
     */
    REACH_AVERAGE_REVENUE,

    /**
     * 
     *                 The number of unique visitors.
     *               
     * 
     */
    REACH,

    /**
     * 
     *                 Number of view-through conversions.
     *                 Deprecated: use {@link #VIEW_THROUGH_CONVERSIONS} instead.
     *               
     * 
     */
    POST_IMPRESSION_ACTIVITIES,

    /**
     * 
     *                 Number of view-through conversions per thousand impressions.
     *                 Deprecated: use {@link #CONVERSIONS_PER_THOUSAND_IMPRESSIONS} instead.
     *               
     * 
     */
    ACTIVITIES_PER_THOUSAND_IMPRESSIONS,

    /**
     * 
     *                 Number of click-through conversions.
     *                 Deprecated: use {@link #CLICK_THROUGH_CONVERSIONS} instead.
     *               
     * 
     */
    POST_CLICK_ACTIVITIES,

    /**
     * 
     *                 Number of click-through conversions per click.
     *                 Deprecated: use {@link #CONVERSIONS_PER_CLICK} instead.
     *               
     * 
     */
    ACTIVITIES_PER_CLICK,

    /**
     * 
     *                 Revenue for view-through conversions.
     *                 Deprecated: use {@link #VIEW_THROUGH_REVENUE} instead.
     *               
     * 
     */
    POST_IMPRESSION_REVENUE,

    /**
     * 
     *                 Revenue for click-through conversions.
     *                 Deprecated: use {@link #CLICK_THROUGH_REVENUE} instead.
     *               
     * 
     */
    POST_CLICK_REVENUE,

    /**
     * 
     *                 Total number of conversions.
     *                 Deprecated: use {@link #TOTAL_CONVERSIONS} instead.
     *               
     * 
     */
    TOTAL_ACTIVITIES,

    /**
     * 
     *                 Total revenue for conversions.
     *                 Deprecated: use {@link #TOTAL_CONVERSION_REVENUE} instead.
     *               
     * 
     */
    TOTAL_ACTIVITY_REVENUE;

    public String value() {
        return name();
    }

    public static Column fromValue(String v) {
        return valueOf(v);
    }

}
