
package com.google.api.ads.dfp.jaxws.v201204;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for CreativeSetError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="CreativeSetError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="VIDEO_FEATURE_REQUIRED"/>
 *     &lt;enumeration value="CANNOT_CREATE_OR_UPDATE_VIDEO_CREATIVES"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "CreativeSetError.Reason")
@XmlEnum
public enum CreativeSetErrorReason {


    /**
     * 
     *                 The 'video' feature is required but not enabled.
     *               
     * 
     */
    VIDEO_FEATURE_REQUIRED,

    /**
     * 
     *                 Video creatives (including overlays, VAST redirects, etc..) cannot be created
     *                 or updated through the API.
     *               
     * 
     */
    CANNOT_CREATE_OR_UPDATE_VIDEO_CREATIVES;

    public String value() {
        return name();
    }

    public static CreativeSetErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
