
package com.google.api.ads.dfp.jaxws.v201204;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *             Gets a {@link CustomFieldPage} of {@link CustomField} objects that satisfy the
 *             given {@link Statement#query}.
 *             The following fields are supported for filtering:
 *             
 *             <table>
 *             <tr>
 *             <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
 *             </tr>
 *             <tr>
 *             <td>{@code id}</td>
 *             <td>{@link CustomField#id}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code entityType}</td>
 *             <td>{@link CustomField#entityType}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code name}</td>
 *             <td>{@link CustomField#name}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code isActive}</td>
 *             <td>{@link CustomField#isActive}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code visibility}</td>
 *             <td>{@link CustomField#visibility}</td>
 *             </tr>
 *             </table>
 *             
 *             
 *             @param filterStatement a Publisher Query Language statement used to filter
 *             a set of custom fields.
 *             @return the custom fields that match the given filter
 *           
 * 
 * <p>Java class for getCustomFieldsByStatement element declaration.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;element name="getCustomFieldsByStatement">
 *   &lt;complexType>
 *     &lt;complexContent>
 *       &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *         &lt;sequence>
 *           &lt;element name="filterStatement" type="{https://www.google.com/apis/ads/publisher/v201204}Statement" minOccurs="0"/>
 *         &lt;/sequence>
 *       &lt;/restriction>
 *     &lt;/complexContent>
 *   &lt;/complexType>
 * &lt;/element>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "filterStatement"
})
@XmlRootElement(name = "getCustomFieldsByStatement")
public class CustomFieldServiceInterfacegetCustomFieldsByStatement {

    protected Statement filterStatement;

    /**
     * Gets the value of the filterStatement property.
     * 
     * @return
     *     possible object is
     *     {@link Statement }
     *     
     */
    public Statement getFilterStatement() {
        return filterStatement;
    }

    /**
     * Sets the value of the filterStatement property.
     * 
     * @param value
     *     allowed object is
     *     {@link Statement }
     *     
     */
    public void setFilterStatement(Statement value) {
        this.filterStatement = value;
    }

}
