
package com.google.api.ads.dfp.jaxws.v201204;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ForecastError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ForecastError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="SERVER_NOT_AVAILABLE"/>
 *     &lt;enumeration value="INTERNAL_ERROR"/>
 *     &lt;enumeration value="NO_FORECAST_YET"/>
 *     &lt;enumeration value="NOT_ENOUGH_INVENTORY"/>
 *     &lt;enumeration value="SUCCESS"/>
 *     &lt;enumeration value="ZERO_LENGTH_RESERVATION"/>
 *     &lt;enumeration value="EXCEEDED_QUOTA"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "ForecastError.Reason")
@XmlEnum
public enum ForecastErrorReason {


    /**
     * 
     *                 The forecast could not be retrieved due to a server side
     *                 connection problem. Please try again soon.
     *               
     * 
     */
    SERVER_NOT_AVAILABLE,

    /**
     * 
     *                 There was an unexpected internal error.
     *               
     * 
     */
    INTERNAL_ERROR,

    /**
     * 
     *                 The forecast could not be retrieved because there is not
     *                 enough forecasting data available yet. It may take up to one week before
     *                 enough data is available.
     *               
     * 
     */
    NO_FORECAST_YET,

    /**
     * 
     *                 There's not enough inventory for the requested reservation.
     *               
     * 
     */
    NOT_ENOUGH_INVENTORY,

    /**
     * 
     *                 No error from forecast.
     *               
     * 
     */
    SUCCESS,

    /**
     * 
     *                 The requested reservation is of zero length.  No forecast is returned.
     *               
     * 
     */
    ZERO_LENGTH_RESERVATION,

    /**
     * 
     *                 The number of requests made per second is too high and has exceeded the
     *                 allowable limit. Please wait before trying your request again. If you see
     *                 this error often, try increasing the wait time between requests.
     *               
     * 
     */
    EXCEEDED_QUOTA;

    public String value() {
        return name();
    }

    public static ForecastErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
