
package com.google.api.ads.dfp.jaxws.v201204;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides operations for creating, updating and retrieving
 *       {@link LineItemCreativeAssociation} objects.
 *       <p>
 *       A line item creative association (LICA) associates a {@link Creative} with a
 *       {@link LineItem}. When a line item is selected to serve, the LICAs specify which
 *       creatives can appear for the ad units that are targeted by the line item. In
 *       order to be associated with a line item, the creative must have a size that
 *       exists within the attribute {@link LineItem#creativeSizes}.
 *       </p>
 *       <p>
 *       Each LICA has a start and end date and time that defines when the creative
 *       should be displayed.
 *       </p>
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "LineItemCreativeAssociationServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface LineItemCreativeAssociationServiceInterface {


    /**
     * 
     *         Creates a new {@link LineItemCreativeAssociation}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link LineItemCreativeAssociation#creativeId}</li>
     *         <li>{@link LineItemCreativeAssociation#lineItemId}</li>
     *         </ul>
     *         
     *         @param lineItemCreativeAssociation the line item creative association to
     *         create
     *         @return the new line item creative association with its ID set
     *       
     * 
     * @param lineItemCreativeAssociation
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "createLineItemCreativeAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacecreateLineItemCreativeAssociation")
    @ResponseWrapper(localName = "createLineItemCreativeAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacecreateLineItemCreativeAssociationResponse")
    public LineItemCreativeAssociation createLineItemCreativeAssociation(
        @WebParam(name = "lineItemCreativeAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        LineItemCreativeAssociation lineItemCreativeAssociation)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link LineItemCreativeAssociation} objects
     *         
     *         @param lineItemCreativeAssociations the line item creative associations to
     *         create
     *         @return the created line item creative associations with their IDs filled
     *         in
     *       
     * 
     * @param lineItemCreativeAssociations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociation>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "createLineItemCreativeAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacecreateLineItemCreativeAssociations")
    @ResponseWrapper(localName = "createLineItemCreativeAssociationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacecreateLineItemCreativeAssociationsResponse")
    public List<LineItemCreativeAssociation> createLineItemCreativeAssociations(
        @WebParam(name = "lineItemCreativeAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        List<LineItemCreativeAssociation> lineItemCreativeAssociations)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link LineItemCreativeAssociation} uniquely identified by the
     *         given line item and creative IDs.
     *         
     *         @param lineItemId the ID of the line item, which must already exist
     *         @param creativeId the ID of the creative, which must already exist
     *         @return the {@code LineItemCreativeAssociation} uniquely identified by the
     *         line item and creative IDs
     *       
     * 
     * @param creativeId
     * @param lineItemId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "getLineItemCreativeAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetLineItemCreativeAssociation")
    @ResponseWrapper(localName = "getLineItemCreativeAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetLineItemCreativeAssociationResponse")
    public LineItemCreativeAssociation getLineItemCreativeAssociation(
        @WebParam(name = "lineItemId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Long lineItemId,
        @WebParam(name = "creativeId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Long creativeId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link LineItemCreativeAssociationPage} of
     *         {@link LineItemCreativeAssociation} objects that satisfy the given
     *         {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code creativeId}</td>
     *         <td>{@link LineItemCreativeAssociation#creativeId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code manualCreativeRotationWeight}</td>
     *         <td>{@link LineItemCreativeAssociation#manualCreativeRotationWeight}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code destinationUrl}</td>
     *         <td>{@link LineItemCreativeAssociation#destinationUrl}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code lineItemId}</td>
     *         <td>{@link LineItemCreativeAssociation#lineItemId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code status}</td>
     *         <td>{@link LineItemCreativeAssociation#status}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code lastModifiedDateTime}</td>
     *         <td>{@link LineItemCreativeAssociation#lastModifiedDateTime}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of line item creative associations
     *         @return the line item creative associations that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "getLineItemCreativeAssociationsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetLineItemCreativeAssociationsByStatement")
    @ResponseWrapper(localName = "getLineItemCreativeAssociationsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetLineItemCreativeAssociationsByStatementResponse")
    public LineItemCreativeAssociationPage getLineItemCreativeAssociationsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns an insite preview URL that references the specified site URL with
     *         the specified creative from the association served to it.
     *         
     *         @param lineItemId the ID of the line item, which must already exist
     *         @param creativeId the ID of the creative, which must already exist
     *         @param siteUrl the URL of the site that the creative should be previewed in
     *         @return a URL that references the specified site URL with the specified
     *         creative served to it
     *       
     * 
     * @param siteUrl
     * @param creativeId
     * @param lineItemId
     * @return
     *     returns java.lang.String
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "getPreviewUrl", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetPreviewUrl")
    @ResponseWrapper(localName = "getPreviewUrlResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfacegetPreviewUrlResponse")
    public String getPreviewUrl(
        @WebParam(name = "lineItemId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Long lineItemId,
        @WebParam(name = "creativeId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Long creativeId,
        @WebParam(name = "siteUrl", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        String siteUrl)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link LineItemCreativeAssociation} objects that match
     *         the given {@link Statement#query}.
     *         
     *         @param lineItemCreativeAssociationAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of line item creative associations
     *         @return the result of the action performed
     *       
     * 
     * @param lineItemCreativeAssociationAction
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201204.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "performLineItemCreativeAssociationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceperformLineItemCreativeAssociationAction")
    @ResponseWrapper(localName = "performLineItemCreativeAssociationActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceperformLineItemCreativeAssociationActionResponse")
    public UpdateResult performLineItemCreativeAssociationAction(
        @WebParam(name = "lineItemCreativeAssociationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        LineItemCreativeAssociationAction lineItemCreativeAssociationAction,
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link LineItemCreativeAssociation}.
     *         
     *         @param lineItemCreativeAssociation the line item creative association to
     *         update
     *         @return the updated line item creative association
     *       
     * 
     * @param lineItemCreativeAssociation
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "updateLineItemCreativeAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceupdateLineItemCreativeAssociation")
    @ResponseWrapper(localName = "updateLineItemCreativeAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceupdateLineItemCreativeAssociationResponse")
    public LineItemCreativeAssociation updateLineItemCreativeAssociation(
        @WebParam(name = "lineItemCreativeAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        LineItemCreativeAssociation lineItemCreativeAssociation)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link LineItemCreativeAssociation} objects
     *         
     *         @param lineItemCreativeAssociations the line item creative associations to
     *         update
     *         @return the updated line item creative associations
     *       
     * 
     * @param lineItemCreativeAssociations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociation>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
    @RequestWrapper(localName = "updateLineItemCreativeAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceupdateLineItemCreativeAssociations")
    @ResponseWrapper(localName = "updateLineItemCreativeAssociationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204", className = "com.google.api.ads.dfp.jaxws.v201204.LineItemCreativeAssociationServiceInterfaceupdateLineItemCreativeAssociationsResponse")
    public List<LineItemCreativeAssociation> updateLineItemCreativeAssociations(
        @WebParam(name = "lineItemCreativeAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201204")
        List<LineItemCreativeAssociation> lineItemCreativeAssociations)
        throws ApiException_Exception
    ;

}
