
package com.google.api.ads.dfp.jaxws.v201206;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for AssetError.Reason.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="AssetError.Reason">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="NON_UNIQUE_NAME"/>
 *     &lt;enumeration value="FILE_NAME_TOO_LONG"/>
 *     &lt;enumeration value="FILE_SIZE_TOO_LARGE"/>
 *     &lt;enumeration value="INVALID_ASSET_ID"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "AssetError.Reason")
@XmlEnum
public enum AssetErrorReason {


    /**
     * 
     *                 An asset name must be unique across advertiser.
     *               
     * 
     */
    NON_UNIQUE_NAME,

    /**
     * 
     *                 The file name is too long.
     *               
     * 
     */
    FILE_NAME_TOO_LONG,

    /**
     * 
     *                 The file size is too large.
     *               
     * 
     */
    FILE_SIZE_TOO_LARGE,

    /**
     * 
     *                 Invalid asset Id.
     *               
     * 
     */
    INVALID_ASSET_ID;

    public String value() {
        return name();
    }

    public static AssetErrorReason fromValue(String v) {
        return valueOf(v);
    }

}
