
package com.google.api.ads.dfp.jaxws.v201206;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides operations for retrieving {@link AudienceSegment} objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "AudienceSegmentServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface AudienceSegmentServiceInterface {


    /**
     * 
     *         Gets a {@link AudienceSegmentPage} of {@link AudienceSegment} objects that satisfy the given
     *         {@link Statement#query}. The following fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th>
     *         <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link AudienceSegment#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link AudienceSegment#name}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter a set of audience
     *         segments
     *         @return the audience segments that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.AudienceSegmentPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "getAudienceSegmentsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.AudienceSegmentServiceInterfacegetAudienceSegmentsByStatement")
    @ResponseWrapper(localName = "getAudienceSegmentsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.AudienceSegmentServiceInterfacegetAudienceSegmentsByStatementResponse")
    public AudienceSegmentPage getAudienceSegmentsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Statement filterStatement)
        throws ApiException_Exception
    ;

}
