
package com.google.api.ads.dfp.jaxws.v201206;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides operations for creating, updating and retrieving {@link Company}
 *       objects.
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "CompanyServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface CompanyServiceInterface {


    /**
     * 
     *         Creates new {@link Company} objects.
     *         
     *         @param companies the companies to create
     *         @return the created companies with their IDs filled in
     *       
     * 
     * @param companies
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201206.Company>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "createCompanies", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacecreateCompanies")
    @ResponseWrapper(localName = "createCompaniesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacecreateCompaniesResponse")
    public List<Company> createCompanies(
        @WebParam(name = "companies", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        List<Company> companies)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates a new {@link Company}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link Company#name}</li>
     *         <li>{@link Company#type}</li>
     *         </ul>
     *         
     *         @param company the company to create
     *         @return the new company with its ID filled in
     *       
     * 
     * @param company
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.Company
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "createCompany", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacecreateCompany")
    @ResponseWrapper(localName = "createCompanyResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacecreateCompanyResponse")
    public Company createCompany(
        @WebParam(name = "company", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Company company)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link CompanyPage} of {@link Company} objects that satisfy the
     *         given {@link Statement#query}. The following fields are supported for
     *         filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code id}</td>
     *         <td>{@link Company#id}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code name}</td>
     *         <td>{@link Company#name}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code type}</td>
     *         <td>{@link Company#type}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code lastModifiedDateTime}</td>
     *         <td>{@link Company#lastModifiedDateTime}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of companies
     *         @return the companies that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.CompanyPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "getCompaniesByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacegetCompaniesByStatement")
    @ResponseWrapper(localName = "getCompaniesByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacegetCompaniesByStatementResponse")
    public CompanyPage getCompaniesByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link Company} uniquely identified by the given ID.
     *         
     *         @param companyId ID of the company, which must already exist
     *         @return the {@code Company} uniquely identified by the given ID
     *       
     * 
     * @param companyId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.Company
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "getCompany", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacegetCompany")
    @ResponseWrapper(localName = "getCompanyResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfacegetCompanyResponse")
    public Company getCompany(
        @WebParam(name = "companyId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Long companyId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Company} objects.
     *         
     *         @param companies the companies to update
     *         @return the updated companies
     *       
     * 
     * @param companies
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201206.Company>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "updateCompanies", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfaceupdateCompanies")
    @ResponseWrapper(localName = "updateCompaniesResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfaceupdateCompaniesResponse")
    public List<Company> updateCompanies(
        @WebParam(name = "companies", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        List<Company> companies)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link Company}.
     *         
     *         @param company the company to update
     *         @return the updated company
     *       
     * 
     * @param company
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.Company
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "updateCompany", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfaceupdateCompany")
    @ResponseWrapper(localName = "updateCompanyResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.CompanyServiceInterfaceupdateCompanyResponse")
    public Company updateCompany(
        @WebParam(name = "company", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Company company)
        throws ApiException_Exception
    ;

}
