
package com.google.api.ads.dfp.jaxws.v201206;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;


/**
 * 
 *             Gets a {@link ContentPage} of {@link Content} objects that satisfy the
 *             given {@link Statement#query}. Additionally, filters on the given value ID
 *             and key ID that the value belongs to.
 *             
 *             The following fields are supported for filtering:
 *             <table>
 *             <tr>
 *             <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
 *             </tr>
 *             <tr>
 *             <td>{@code id}</td>
 *             <td>{@link Content#id}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code status}</td>
 *             <td>{@link Content#status}</td>
 *             </tr>
 *             <tr>
 *             <td>{@code name}</td>
 *             <td>{@link Content#name}</td>
 *             </tr>
 *             </table>
 *             
 *             @params filterStatement a Publisher Query Language statement used to
 *             filter a set of content
 *             @param customTargetingValueId the id of the value to match
 *             @return the content that matches the given filter
 *           
 * 
 * <p>Java class for getContentByStatementAndCustomTargetingValue element declaration.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;element name="getContentByStatementAndCustomTargetingValue">
 *   &lt;complexType>
 *     &lt;complexContent>
 *       &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *         &lt;sequence>
 *           &lt;element name="filterStatement" type="{https://www.google.com/apis/ads/publisher/v201206}Statement" minOccurs="0"/>
 *           &lt;element name="customTargetingValueId" type="{http://www.w3.org/2001/XMLSchema}long" minOccurs="0"/>
 *         &lt;/sequence>
 *       &lt;/restriction>
 *     &lt;/complexContent>
 *   &lt;/complexType>
 * &lt;/element>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "", propOrder = {
    "filterStatement",
    "customTargetingValueId"
})
@XmlRootElement(name = "getContentByStatementAndCustomTargetingValue")
public class ContentServiceInterfacegetContentByStatementAndCustomTargetingValue {

    protected Statement filterStatement;
    protected Long customTargetingValueId;

    /**
     * Gets the value of the filterStatement property.
     * 
     * @return
     *     possible object is
     *     {@link Statement }
     *     
     */
    public Statement getFilterStatement() {
        return filterStatement;
    }

    /**
     * Sets the value of the filterStatement property.
     * 
     * @param value
     *     allowed object is
     *     {@link Statement }
     *     
     */
    public void setFilterStatement(Statement value) {
        this.filterStatement = value;
    }

    /**
     * Gets the value of the customTargetingValueId property.
     * 
     * @return
     *     possible object is
     *     {@link Long }
     *     
     */
    public Long getCustomTargetingValueId() {
        return customTargetingValueId;
    }

    /**
     * Sets the value of the customTargetingValueId property.
     * 
     * @param value
     *     allowed object is
     *     {@link Long }
     *     
     */
    public void setCustomTargetingValueId(Long value) {
        this.customTargetingValueId = value;
    }

}
