
package com.google.api.ads.dfp.jaxws.v201206;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for estimating traffic (clicks/impressions) for line items.
 *       Forecasts can be provided for {@link LineItem} objects that exist in the
 *       system or which have not had an ID set yet.
 *       
 *       <h4>Sandbox behavior</h4>
 *       
 *       <p>The sandbox environment is unable to provide forecasts that would be
 *       comparable to the production environment because forecasts require traffic
 *       history. In the sandbox environment, a consistent behavior can be expected
 *       for forecast requests, according to the following rules:
 *       
 *       <table>
 *       <tr>
 *       <th colspan="2">Inputs<br/>({@code LineItem} Fields)</th>
 *       <th colspan="4">Outputs<br/>({@code Forecast} Fields)</th>
 *       </tr>
 *       <tr>
 *       <th>{@link LineItem#lineItemType lineItemType}</th>
 *       <th>{@link LineItem#unitsBought unitsBought}</th>
 *       <th>{@link Forecast#availableUnits availableUnits}</th>
 *       <th>{@link Forecast#forecastUnits forecastUnits (matchedUnits)}</th>
 *       <th>{@link Forecast#deliveredUnits deliveredUnits}</th>
 *       <th>Exception</td>
 *       </tr>
 *       <tr>
 *       <td>Sponsorship</td>
 *       <td>20</td>
 *       <td>&ndash;&ndash;</td>
 *       <td>&ndash;&ndash;</td>
 *       <td>&ndash;&ndash;</td>
 *       <td>
 *       {@link ForecastError.Reason#SERVER_NOT_AVAILABLE SERVER_NOT_AVAILABLE}
 *       </td>
 *       </tr>
 *       <tr>
 *       <td>Sponsorship</td>
 *       <td>50</td>
 *       <td>1,200,000</td>
 *       <td>6,000,000</td>
 *       <td>600,000<br/>For prospective: 0</td>
 *       <td>&ndash;&ndash;</td>
 *       </tr>
 *       <tr>
 *       <td>Sponsorship</td>
 *       <td>!= 20 and <br/> != 50</td>
 *       <td>1,200,000</td>
 *       <td>1,200,000</td>
 *       <td>600,000<br/>For prospective: 0</td>
 *       <td>&ndash;&ndash;</td>
 *       </tr>
 *       <tr>
 *       <td>Not Sponsorship</td>
 *       <td>&lt;= 1,000,000</td>
 *       <td>unitsBought * 2</td>
 *       <td>availableUnits * 3</td>
 *       <td>600,000<br/>For prospective: 0</td>
 *       <td>&ndash;&ndash;</td>
 *       </tr>
 *       <tr>
 *       <td>Not Sponsorship</td>
 *       <td>&gt; 1,000,000</td>
 *       <td>unitsBought / 2</td>
 *       <td>availableUnits * 3</td>
 *       <td>600,000<br/>For prospective: 0</td>
 *       <td>&ndash;&ndash;</td>
 *       </tr>
 *       </table>
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "ForecastServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface ForecastServiceInterface {


    /**
     * 
     *         Gets a {@link Forecast} on a prospective {@link LineItem} object. Valid
     *         values for {@link LineItem#lineItemType} are
     *         {@link LineItemType#SPONSORSHIP} and {@link LineItemType#STANDARD}. Other
     *         values will result in
     *         {@link ReservationDetailsError.Reason#LINE_ITEM_TYPE_NOT_ALLOWED}.
     *         
     *         @param lineItem the target of the forecast. Must be a prospective line item
     *         that has not yet been booked in the system. i.e. {@link LineItem#id}
     *         must be null.
     *         @return the forecasted traffic estimates
     *       
     * 
     * @param lineItem
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.Forecast
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "getForecast", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.ForecastServiceInterfacegetForecast")
    @ResponseWrapper(localName = "getForecastResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.ForecastServiceInterfacegetForecastResponse")
    public Forecast getForecast(
        @WebParam(name = "lineItem", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        LineItem lineItem)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link Forecast} for an existing {@link LineItem} object. Only
     *         line items having type {@link LineItemType#SPONSORSHIP} or
     *         {@link LineItemType#STANDARD} are valid. Other types will result in
     *         {@link ReservationDetailsError.Reason#LINE_ITEM_TYPE_NOT_ALLOWED}.
     *         
     *         @param lineItemId the ID of a {@link LineItem} to run the forecast on.
     *         @return the forecasted traffic estimates
     *       
     * 
     * @param lineItemId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201206.Forecast
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
    @RequestWrapper(localName = "getForecastById", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.ForecastServiceInterfacegetForecastById")
    @ResponseWrapper(localName = "getForecastByIdResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206", className = "com.google.api.ads.dfp.jaxws.v201206.ForecastServiceInterfacegetForecastByIdResponse")
    public Forecast getForecastById(
        @WebParam(name = "lineItemId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201206")
        Long lineItemId)
        throws ApiException_Exception
    ;

}
