
package com.google.api.ads.dfp.jaxws.v201208;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for executing a PQL {@link Statement} to retrieve
 *       information from the system. In order to support the selection of columns of
 *       interest from various tables, {@link Statement} objects support a "select"
 *       clause.
 *       <p>
 *       An example query text might be {@code "select CountryCode, CountryName from
 *       Country"}, where {@code CountryCode} and {@code CountryName} are
 *       columns of interest and {@code Country} is the table.
 *       </p>
 *       <p>
 *       The following tables are supported:
 *       </p>
 *       <br/>
 *       <h4>Country</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the country</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>Country code as defined by ISO 3166-1 alpha-2</td>
 *       </tr>
 *       <tr>
 *       <td>CountryName</td>
 *       <td>The name of the country</td>
 *       </tr>
 *       <tr>
 *       <td>CurrencyCode</td>
 *       <td>Currency code as defined by ISO 4217</td>
 *       </tr>
 *       <tr>
 *       <td>Targetable</td>
 *       <td>Indicates whether geographical targeting is allowed</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Region</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the region</td>
 *       </tr>
 *       <tr>
 *       <td>RegionCode</td>
 *       <td>Region code as defined by ISO 3166-2</td>
 *       </tr>
 *       <tr>
 *       <td>RegionName</td>
 *       <td>The name of the region</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>Country code as defined by ISO 3166-1 alpha-2</td>
 *       </tr>
 *       <tr>
 *       <td>CountryName</td>
 *       <td>The name of the country</td>
 *       </tr>
 *       <tr>
 *       <td>Targetable</td>
 *       <td>Indicates whether geographical targeting is allowed</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Metro</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the metro</td>
 *       </tr>
 *       <tr>
 *       <td>MetroCode</td>
 *       <td>3 digit metro code required for metro targeting</td>
 *       </tr>
 *       <tr>
 *       <td>MetroName</td>
 *       <td>The name of the metro</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>Country code as defined by ISO 3166-1 alpha-2</td>
 *       </tr>
 *       <tr>
 *       <td>CountryName</td>
 *       <td>The name of the country</td>
 *       </tr>
 *       <tr>
 *       <td>Targetable</td>
 *       <td>Indicates whether geographical targeting is allowed</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>City</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the city</td>
 *       </tr>
 *       <tr>
 *       <td>CityName</td>
 *       <td>The city name</td>
 *       </tr>
 *       <tr>
 *       <td>MetroCode</td>
 *       <td>3 digit metro code that the city belongs to</td>
 *       </tr>
 *       <tr>
 *       <td>MetroName</td>
 *       <td>The name of the metro</td>
 *       </tr>
 *       <tr>
 *       <td>RegionCode</td>
 *       <td>Region code as defined by ISO 3166-2</td>
 *       </tr>
 *       <tr>
 *       <td>RegionName</td>
 *       <td>The name of the region</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>Country code as defined by ISO 3166-1 alpha-2</td>
 *       </tr>
 *       <tr>
 *       <td>CountryName</td>
 *       <td>The name of the country</td>
 *       </tr>
 *       <tr>
 *       <td>Targetable</td>
 *       <td>Indicates whether geographical targeting is allowed</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Postal_Code</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope = "col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the postal code</td>
 *       </tr>
 *       <tr>
 *       <td>PostalCode</td>
 *       <td>Postal code</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>Country code as defined by ISO 3166-1 alpha-2</td>
 *       </tr>
 *       <tr>
 *       <td>Targetable</td>
 *       <td>Indicates whether geographical targeting is allowed</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Bandwidth_Group</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the bandwidth group</td>
 *       </tr>
 *       <tr>
 *       <td>BandwidthName</td>
 *       <td>Name of the bandwidth group</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Browser</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the browser</td>
 *       </tr>
 *       <tr>
 *       <td>BrowserName</td>
 *       <td>Name of the browser</td>
 *       </tr>
 *       <tr>
 *       <td>MajorVersion</td>
 *       <td>Major version of the browser</td>
 *       </tr>
 *       <tr>
 *       <td>MinorVersion</td>
 *       <td>Minor version of the browser</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Browser_Language</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the browser language</td>
 *       </tr>
 *       <tr>
 *       <td>BrowserLanguageName</td>
 *       <td>Browser's language</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Device_Capability</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the device capability</td>
 *       </tr>
 *       <tr>
 *       <td>DeviceCapabilityName</td>
 *       <td>Name of the device capability</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Device_Category</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the device category</td>
 *       </tr>
 *       <tr>
 *       <td>DeviceCategoryName</td>
 *       <td>Name of the device category</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Device_Manufacturer</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the device manufacturer</td>
 *       </tr>
 *       <tr>
 *       <td>MobileDeviceManufacturerName</td>
 *       <td>Name of the device manufacturer</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Mobile_Carrier</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the mobile carrier</td>
 *       </tr>
 *       <tr>
 *       <td>CountryCode</td>
 *       <td>The country code of the mobile carrier</td>
 *       </tr>
 *       <tr>
 *       <td>MobileCarrierName</td>
 *       <td>Name of the mobile carrier</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Mobile_Device</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the mobile device</td>
 *       </tr>
 *       <tr>
 *       <td>MobileDeviceManufacturerId</td>
 *       <td>Id of the device manufacturer</td>
 *       </tr>
 *       <tr>
 *       <td>MobileDeviceName</td>
 *       <td>Name of the mobile device</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Mobile_Device_Submodel</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the mobile device submodel</td>
 *       </tr>
 *       <tr>
 *       <td>MobileDeviceId</td>
 *       <td>Id of the mobile device</td>
 *       </tr>
 *       <tr>
 *       <td>MobileDeviceSubmodelName</td>
 *       <td>Name of the mobile device submodel</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Operating_System</h4>
 *       <table>
 *       <tr>
 *       <th scope = "col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the operating system</td>
 *       </tr>
 *       <tr>
 *       <td>OperatingSystemName</td>
 *       <td>Name of the operating system</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Operating_System_Version</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the operating system version</td>
 *       </tr>
 *       <tr>
 *       <td>OperatingSystemId</td>
 *       <td>Id of the operating system</td>
 *       </tr>
 *       <tr>
 *       <td>MajorVersion</td>
 *       <td>The operating system major version</td>
 *       </tr>
 *       <tr>
 *       <td>MinorVersion</td>
 *       <td>The operating system minor version</td>
 *       </tr>
 *       <tr>
 *       <td>MicroVersion</td>
 *       <td>The operating system micro version</td>
 *       </tr>
 *       </table>
 *       
 *       <br/>
 *       <h4>Third_Party_Company</h4>
 *       <table>
 *       <tr>
 *       <th scope="col">Column Name</th>
 *       <th scope="col">Description</th>
 *       </tr>
 *       <tr>
 *       <td>Id</td>
 *       <td>Unique identifier for the third party company</td>
 *       </tr>
 *       <tr>
 *       <td>Name</td>
 *       <td>The third party company name</td>
 *       </tr>
 *       <tr>
 *       <td>Type</td>
 *       <td>The third party company type</td>
 *       </tr>
 *       <tr>
 *       <td>Status</td>
 *       <td>The status of the third party company</td>
 *       </tr>
 *       </table>
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "PublisherQueryLanguageServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface PublisherQueryLanguageServiceInterface {


    /**
     * 
     *         Retrieves rows of data that satisfy the given {@link Statement#query} from
     *         the system.
     *         
     *         @param selectStatement a Publisher Query Language statement used to
     *         specify what data needs to returned
     *         
     *         @return a result set of data that matches the given filter
     *       
     * 
     * @param selectStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.ResultSet
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "select", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.PublisherQueryLanguageServiceInterfaceselect")
    @ResponseWrapper(localName = "selectResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.PublisherQueryLanguageServiceInterfaceselectResponse")
    public ResultSet select(
        @WebParam(name = "selectStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Statement selectStatement)
        throws ApiException_Exception
    ;

}
