
package com.google.api.ads.dfp.jaxws.v201208;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * 
 *       Provides methods for creating, updating, and retrieving
 *       {@link UserTeamAssociation} objects.
 *       <p>
 *       UserTeamAssociation objects are used to add users to teams in order to define
 *       access to entities such as companies, inventory and orders and to override
 *       the team's access type to orders for a user.
 *       </p>
 *     
 * 
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.1.6
 * Generated source version: 2.1
 * 
 */
@WebService(name = "UserTeamAssociationServiceInterface", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface UserTeamAssociationServiceInterface {


    /**
     * 
     *         Creates a new {@code UserTeamAssociation}.
     *         
     *         The following fields are required:
     *         <ul>
     *         <li>{@link UserTeamAssociation#teamId}</li>
     *         <li>{@link UserTeamAssociation#userId}</li>
     *         </ul>
     *         
     *         @param userTeamAssociation the user team association to create
     *         @return the user team association with its ID filled in
     *       
     * 
     * @param userTeamAssociation
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createUserTeamAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacecreateUserTeamAssociation")
    @ResponseWrapper(localName = "createUserTeamAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacecreateUserTeamAssociationResponse")
    public UserTeamAssociation createUserTeamAssociation(
        @WebParam(name = "userTeamAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        UserTeamAssociation userTeamAssociation)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Creates new {@link UserTeamAssociation} objects.
     *         
     *         @param userTeamAssociations the user team associations to create
     *         @return the created user team associations with their IDs filled in
     *       
     * 
     * @param userTeamAssociations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociation>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "createUserTeamAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacecreateUserTeamAssociations")
    @ResponseWrapper(localName = "createUserTeamAssociationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacecreateUserTeamAssociationsResponse")
    public List<UserTeamAssociation> createUserTeamAssociations(
        @WebParam(name = "userTeamAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<UserTeamAssociation> userTeamAssociations)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Returns the {@link UserTeamAssociation} uniquely identified by the given
     *         user and team IDs.
     *         
     *         @param teamId the ID of the team, which must already exist
     *         @param userId the ID of the user, which must already exist
     *         @return the {@code UserTeamAssociation} uniquely identified by the
     *         user and team IDs
     *       
     * 
     * @param userId
     * @param teamId
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "getUserTeamAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacegetUserTeamAssociation")
    @ResponseWrapper(localName = "getUserTeamAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacegetUserTeamAssociationResponse")
    public UserTeamAssociation getUserTeamAssociation(
        @WebParam(name = "teamId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Long teamId,
        @WebParam(name = "userId", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Long userId)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Gets a {@link UserTeamAssociationPage} of {@link UserTeamAssociation}
     *         objects that satisfy the given {@link Statement#query}. The following
     *         fields are supported for filtering:
     *         
     *         <table>
     *         <tr>
     *         <th scope="col">PQL Property</th> <th scope="col">Object Property</th>
     *         </tr>
     *         <tr>
     *         <td>{@code userId}</td>
     *         <td>{@link UserTeamAssociation#userId}</td>
     *         </tr>
     *         <tr>
     *         <td>{@code teamId}</td>
     *         <td>{@link UserTeamAssociation#teamId}</td>
     *         </tr>
     *         </table>
     *         
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of user team associations
     *         @return the user team associations that match the given filter
     *       
     * 
     * @param filterStatement
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationPage
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "getUserTeamAssociationsByStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacegetUserTeamAssociationsByStatement")
    @ResponseWrapper(localName = "getUserTeamAssociationsByStatementResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfacegetUserTeamAssociationsByStatementResponse")
    public UserTeamAssociationPage getUserTeamAssociationsByStatement(
        @WebParam(name = "filterStatement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Statement filterStatement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Performs actions on {@link UserTeamAssociation} objects that match the
     *         given {@link Statement#query}.
     *         
     *         @param userTeamAssociationAction the action to perform
     *         @param filterStatement a Publisher Query Language statement used to filter
     *         a set of user team associations
     *         @return the result of the action performed
     *       
     * 
     * @param statement
     * @param userTeamAssociationAction
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UpdateResult
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "performUserTeamAssociationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceperformUserTeamAssociationAction")
    @ResponseWrapper(localName = "performUserTeamAssociationActionResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceperformUserTeamAssociationActionResponse")
    public UpdateResult performUserTeamAssociationAction(
        @WebParam(name = "userTeamAssociationAction", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        UserTeamAssociationAction userTeamAssociationAction,
        @WebParam(name = "statement", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        Statement statement)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link UserTeamAssociation}.
     *         
     *         @param userTeamAssociation the user team association to update
     *         @return the updated user team association
     *       
     * 
     * @param userTeamAssociation
     * @return
     *     returns com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociation
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateUserTeamAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceupdateUserTeamAssociation")
    @ResponseWrapper(localName = "updateUserTeamAssociationResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceupdateUserTeamAssociationResponse")
    public UserTeamAssociation updateUserTeamAssociation(
        @WebParam(name = "userTeamAssociation", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        UserTeamAssociation userTeamAssociation)
        throws ApiException_Exception
    ;

    /**
     * 
     *         Updates the specified {@link UserTeamAssociation} objects.
     *         
     *         @param userTeamAssociations the user team associations to update
     *         @return the updated user team associations
     *       
     * 
     * @param userTeamAssociations
     * @return
     *     returns java.util.List<com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociation>
     * @throws ApiException_Exception
     */
    @WebMethod
    @WebResult(name = "rval", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
    @RequestWrapper(localName = "updateUserTeamAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceupdateUserTeamAssociations")
    @ResponseWrapper(localName = "updateUserTeamAssociationsResponse", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208", className = "com.google.api.ads.dfp.jaxws.v201208.UserTeamAssociationServiceInterfaceupdateUserTeamAssociationsResponse")
    public List<UserTeamAssociation> updateUserTeamAssociations(
        @WebParam(name = "userTeamAssociations", targetNamespace = "https://www.google.com/apis/ads/publisher/v201208")
        List<UserTeamAssociation> userTeamAssociations)
        throws ApiException_Exception
    ;

}
