/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.appengine;

import com.google.api.client.appengine.UrlFetchResponse;
import com.google.api.client.appengine.UrlFetchTransport;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.appengine.api.urlfetch.FetchOptions;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.ResponseTooLargeException;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;

final class UrlFetchRequest
extends LowLevelHttpRequest {
    private HttpContent content;
    private final UrlFetchTransport transport;
    private final HTTPMethod method;
    private final HTTPRequest request;

    UrlFetchRequest(UrlFetchTransport transport, String requestMethod, String url) throws IOException {
        this.transport = transport;
        this.method = HTTPMethod.valueOf((String)requestMethod);
        FetchOptions options = FetchOptions.Builder.doNotFollowRedirects().disallowTruncate();
        this.request = new HTTPRequest(new URL(url), this.method, options);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(new HTTPHeader(name, value));
    }

    public LowLevelHttpResponse execute() throws IOException {
        double deadline;
        if (this.content != null) {
            long contentLength;
            this.addHeader("Content-Type", this.content.getType());
            String contentEncoding = this.content.getEncoding();
            if (contentEncoding != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.content.getLength()) >= 0L) {
                this.addHeader("Content-Length", Long.toString(contentLength));
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.content.writeTo((OutputStream)out);
            this.request.setPayload(out.toByteArray());
        }
        if ((deadline = this.transport.deadline.doubleValue()) >= 0.0) {
            this.request.getFetchOptions().setDeadline(Double.valueOf(deadline));
        }
        URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        try {
            HTTPResponse response = service.fetch(this.request);
            return new UrlFetchResponse(response);
        }
        catch (ResponseTooLargeException e) {
            IOException ioException = new IOException();
            ioException.initCause(e);
            throw ioException;
        }
    }

    public void setContent(HttpContent content) {
        this.content = content;
    }
}

