/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.GZipContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteIntercepter;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.LogContent;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpTransport;
import com.google.api.client.util.Strings;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class HttpRequest {
    private static final String USER_AGENT_SUFFIX = "Google-API-Java-Client/1.0.10-alpha";
    public HttpHeaders headers;
    public boolean disableContentLogging;
    public HttpContent content;
    public final HttpTransport transport;
    public String method;
    public GenericUrl url;

    HttpRequest(HttpTransport transport, String method) {
        this.transport = transport;
        this.headers = transport.defaultHeaders.clone();
        this.method = method;
    }

    public void setUrl(String encodedUrl) {
        this.url = new GenericUrl(encodedUrl);
    }

    public HttpResponse execute() throws IOException {
        LowLevelHttpRequest lowLevelHttpRequest;
        HttpTransport transport = this.transport;
        for (HttpExecuteIntercepter intercepter : transport.intercepters) {
            intercepter.intercept(this);
        }
        LowLevelHttpTransport lowLevelHttpTransport = HttpTransport.useLowLevelHttpTransport();
        String method = this.method;
        GenericUrl url = this.url;
        String urlString = url.build();
        if (method.equals("DELETE")) {
            lowLevelHttpRequest = lowLevelHttpTransport.buildDeleteRequest(urlString);
        } else if (method.equals("GET")) {
            lowLevelHttpRequest = lowLevelHttpTransport.buildGetRequest(urlString);
        } else if (method.equals("PATCH")) {
            if (!lowLevelHttpTransport.supportsPatch()) {
                throw new IllegalArgumentException("HTTP transport doesn't support PATCH");
            }
            lowLevelHttpRequest = lowLevelHttpTransport.buildPatchRequest(urlString);
        } else if (method.equals("POST")) {
            lowLevelHttpRequest = lowLevelHttpTransport.buildPostRequest(urlString);
        } else if (method.equals("PUT")) {
            lowLevelHttpRequest = lowLevelHttpTransport.buildPutRequest(urlString);
        } else {
            throw new IllegalArgumentException("illegal method: " + method);
        }
        Logger logger = HttpTransport.LOGGER;
        boolean loggable = logger.isLoggable(Level.CONFIG);
        StringBuilder logbuf = null;
        if (loggable) {
            logbuf = new StringBuilder();
            logbuf.append("-------------- REQUEST  --------------").append(Strings.LINE_SEPARATOR);
            logbuf.append(method).append(' ').append(urlString).append(Strings.LINE_SEPARATOR);
        }
        HttpHeaders headers = this.headers;
        headers.userAgent = headers.userAgent == null ? USER_AGENT_SUFFIX : headers.userAgent + " Google-API-Java-Client/1.0.10-alpha";
        HashSet<String> headerNames = new HashSet<String>();
        for (Map.Entry headerEntry : this.headers.entrySet()) {
            String name = (String)headerEntry.getKey();
            String lowerCase = name.toLowerCase();
            if (!headerNames.add(lowerCase)) {
                throw new IllegalArgumentException("multiple headers of the same name (headers are case insensitive): " + lowerCase);
            }
            Object value = headerEntry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                for (Object repeatedValue : (Collection)value) {
                    HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, repeatedValue);
                }
                continue;
            }
            HttpRequest.addHeader(logger, logbuf, lowLevelHttpRequest, name, value);
        }
        HttpContent content = this.content;
        if (content != null) {
            String contentEncoding = content.getEncoding();
            long contentLength = content.getLength();
            String contentType = content.getType();
            if (contentLength != 0L && contentEncoding == null && contentType != null && contentType.startsWith("application/") || contentType.startsWith("text/")) {
                if (loggable && !this.disableContentLogging || logger.isLoggable(Level.ALL)) {
                    content = new LogContent(content, contentType, contentEncoding, contentLength);
                }
                if (contentLength >= 256L) {
                    content = new GZipContent(content, contentType);
                    contentEncoding = content.getEncoding();
                    contentLength = content.getLength();
                }
            }
            if (loggable) {
                logbuf.append("Content-Type: " + contentType).append(Strings.LINE_SEPARATOR);
                if (contentEncoding != null) {
                    logbuf.append("Content-Encoding: " + contentEncoding).append(Strings.LINE_SEPARATOR);
                }
                if (contentLength >= 0L) {
                    logbuf.append("Content-Length: " + contentLength).append(Strings.LINE_SEPARATOR);
                }
            }
            lowLevelHttpRequest.setContent(content);
        }
        if (loggable) {
            logger.config(logbuf.toString());
        }
        HttpResponse response = new HttpResponse(transport, lowLevelHttpRequest.execute());
        if (!response.isSuccessStatusCode) {
            throw new HttpResponseException(response);
        }
        return response;
    }

    private static void addHeader(Logger logger, StringBuilder logbuf, LowLevelHttpRequest lowLevelHttpRequest, String name, Object value) {
        String stringValue = value.toString();
        if (logbuf != null) {
            logbuf.append(name).append(": ");
            if ("Authorization".equals(name) && !logger.isLoggable(Level.ALL)) {
                logbuf.append("<Not Logged>");
            } else {
                logbuf.append(stringValue);
            }
            logbuf.append(Strings.LINE_SEPARATOR);
        }
        lowLevelHttpRequest.addHeader(name, stringValue);
    }
}

