/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.Key;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeaders
extends GenericData {
    @Key(value="Accept")
    public String accept;
    @Key(value="Accept-Encoding")
    public String acceptEncoding = "gzip";
    @Key(value="Authorization")
    public String authorization;
    @Key(value="Cache-Control")
    public String cacheControl;
    @Key(value="Content-Encoding")
    public String contentEncoding;
    @Key(value="Content-Length")
    public String contentLength;
    @Key(value="Content-MD5")
    public String contentMD5;
    @Key(value="Content-Range")
    public String contentRange;
    @Key(value="Content-Type")
    public String contentType;
    @Key(value="Date")
    public String date;
    @Key(value="ETag")
    public String etag;
    @Key(value="Expires")
    public String expires;
    @Key(value="If-Modified-Since")
    public String ifModifiedSince;
    @Key(value="If-Match")
    public String ifMatch;
    @Key(value="If-None-Match")
    public String ifNoneMatch;
    @Key(value="If-Unmodified-Since")
    public String ifUnmodifiedSince;
    @Key(value="Last-Modified")
    public String lastModified;
    @Key(value="Location")
    public String location;
    @Key(value="MIME-Version")
    public String mimeVersion;
    @Key(value="Range")
    public String range;
    @Key(value="Retry-After")
    public String retryAfter;
    @Key(value="User-Agent")
    public String userAgent;
    @Key(value="WWW-Authenticate")
    public String authenticate;

    public HttpHeaders clone() {
        return (HttpHeaders)super.clone();
    }

    public Map<String, Collection<Object>> canonicalMap() {
        HashMap<String, Collection<Object>> result = new HashMap<String, Collection<Object>>();
        for (Map.Entry entry : this.entrySet()) {
            String canonicalName = ((String)entry.getKey()).toLowerCase();
            if (result.containsKey(canonicalName)) {
                throw new IllegalArgumentException("multiple headers of the same name (headers are case insensitive): " + canonicalName);
            }
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Collection) {
                Collection collectionValue = (Collection)value;
                result.put(canonicalName, Collections.unmodifiableCollection(collectionValue));
                continue;
            }
            result.put(canonicalName, Collections.singleton(value));
        }
        return result;
    }

    static HashMap<String, String> getFieldNameMap(Class<? extends HttpHeaders> headersClass) {
        HashMap<String, String> fieldNameMap = new HashMap<String, String>();
        for (String keyName : ClassInfo.of(headersClass).getKeyNames()) {
            fieldNameMap.put(keyName.toLowerCase(), keyName);
        }
        return fieldNameMap;
    }
}

