/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.xml;

import com.google.api.client.util.ClassInfo;
import com.google.api.client.util.FieldInfo;
import com.google.api.client.xml.DefaultXmlParserFactory;
import com.google.api.client.xml.GenericXml;
import com.google.api.client.xml.XmlNamespaceDictionary;
import com.google.api.client.xml.XmlParserFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml {
    public static XmlParserFactory parserFactory;

    private static XmlParserFactory getParserFactory() throws XmlPullParserException {
        XmlParserFactory parserFactory = Xml.parserFactory;
        if (parserFactory == null) {
            parserFactory = Xml.parserFactory = DefaultXmlParserFactory.getInstance();
        }
        return parserFactory;
    }

    public static XmlSerializer createSerializer() {
        try {
            return Xml.getParserFactory().createSerializer();
        }
        catch (XmlPullParserException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static XmlPullParser createParser() throws XmlPullParserException {
        XmlPullParser result = Xml.getParserFactory().createParser();
        if (!result.getFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces")) {
            throw new IllegalStateException("XML pull parser must have namespace-aware feature");
        }
        return result;
    }

    public static String toStringOf(Object element) {
        return new XmlNamespaceDictionary().toStringOf(null, element);
    }

    private static void parseValue(String stringValue, Field field, Object destination, GenericXml genericXml, Map<String, Object> destinationMap, String name) {
        if (field == null) {
            if (genericXml != null) {
                genericXml.set(name, Xml.parseValue(stringValue, null));
            } else if (destinationMap != null) {
                destinationMap.put(name, Xml.parseValue(stringValue, null));
            }
        } else {
            Class<?> fieldClass = field.getType();
            if (Modifier.isFinal(field.getModifiers()) && !FieldInfo.isPrimitive(fieldClass)) {
                throw new IllegalArgumentException("final sub-element fields are not supported");
            }
            Object fieldValue = Xml.parseValue(stringValue, fieldClass);
            FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)fieldValue);
        }
    }

    public static void parseElement(XmlPullParser parser, Object destination, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        Xml.parseElementInternal(parser, destination, namespaceDictionary, customizeParser);
    }

    private static boolean parseElementInternal(XmlPullParser parser, Object destination, XmlNamespaceDictionary namespaceDictionary, CustomizeParser customizeParser) throws IOException, XmlPullParserException {
        Class<?> destinationClass = destination == null ? null : destination.getClass();
        GenericXml genericXml = destination instanceof GenericXml ? (GenericXml)destination : null;
        boolean isMap = genericXml == null && destination instanceof Map;
        Map destinationMap = isMap ? (Map)destination : null;
        ClassInfo classInfo = isMap || destination == null ? null : ClassInfo.of(destinationClass);
        int eventType = parser.getEventType();
        if (parser.getEventType() == 0) {
            eventType = parser.next();
        }
        if (eventType != 2) {
            throw new IllegalArgumentException("wrong event type: " + eventType);
        }
        String prefix = parser.getPrefix();
        String alias = prefix == null ? "" : prefix;
        namespaceDictionary.addNamespace(alias, parser.getNamespace());
        if (genericXml != null) {
            genericXml.namespaceDictionary = namespaceDictionary;
            String name = parser.getName();
            String string = genericXml.name = prefix == null ? name : prefix + ":" + name;
        }
        if (destination != null) {
            int attributeCount = parser.getAttributeCount();
            for (int i = 0; i < attributeCount; ++i) {
                String attributeName = parser.getAttributeName(i);
                String attributePrefix = parser.getAttributePrefix(i);
                String attributeNamespace = parser.getAttributeNamespace(i);
                if (attributePrefix != null) {
                    namespaceDictionary.addNamespace(attributePrefix, attributeNamespace);
                }
                String fieldName = Xml.getFieldName(true, attributePrefix, attributeNamespace, attributeName);
                Field field = isMap ? null : classInfo.getField(fieldName);
                Xml.parseValue(parser.getAttributeValue(i), field, destination, genericXml, destinationMap, fieldName);
            }
        }
        while (true) {
            int event = parser.next();
            switch (event) {
                case 1: {
                    return true;
                }
                case 3: {
                    return customizeParser != null && customizeParser.stopAfterEndTag(parser.getNamespace(), parser.getName());
                }
                case 4: {
                    if (destination == null) break;
                    String textFieldName = "text()";
                    Field field = isMap ? null : classInfo.getField(textFieldName);
                    Xml.parseValue(parser.getText(), field, destination, genericXml, destinationMap, textFieldName);
                    break;
                }
                case 2: {
                    if (customizeParser != null && customizeParser.stopBeforeStartTag(parser.getNamespace(), parser.getName())) {
                        return true;
                    }
                    if (destination == null) {
                        int level = 1;
                        while (level != 0) {
                            switch (parser.next()) {
                                case 1: {
                                    return true;
                                }
                                case 2: {
                                    ++level;
                                    break;
                                }
                                case 3: {
                                    --level;
                                }
                            }
                        }
                        break;
                    }
                    String fieldName = Xml.getFieldName(false, parser.getPrefix(), parser.getNamespace(), parser.getName());
                    Field field = isMap ? null : classInfo.getField(fieldName);
                    Class<?> fieldClass = field == null ? null : field.getType();
                    boolean isStopped = false;
                    if (field == null && !isMap && genericXml == null || field != null && FieldInfo.isPrimitive(fieldClass)) {
                        int level = 1;
                        while (level != 0) {
                            switch (parser.next()) {
                                case 1: {
                                    return true;
                                }
                                case 2: {
                                    ++level;
                                    break;
                                }
                                case 3: {
                                    --level;
                                    break;
                                }
                                case 4: {
                                    if (level != 1) break;
                                    Xml.parseValue(parser.getText(), field, destination, genericXml, destinationMap, fieldName);
                                }
                            }
                        }
                    } else if (field == null || Map.class.isAssignableFrom(fieldClass)) {
                        Map mapValue = ClassInfo.newMapInstance(fieldClass);
                        isStopped = Xml.parseElementInternal(parser, mapValue, namespaceDictionary, customizeParser);
                        if (isMap) {
                            ArrayList<Map> list = (ArrayList<Map>)destinationMap.get(fieldName);
                            if (list == null) {
                                list = new ArrayList<Map>(1);
                                destinationMap.put(fieldName, list);
                            }
                            list.add(mapValue);
                        } else if (field != null) {
                            FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)mapValue);
                        } else {
                            GenericXml atom = (GenericXml)destination;
                            ArrayList<Map> list = (ArrayList<Map>)atom.get(fieldName);
                            if (list == null) {
                                list = new ArrayList<Map>(1);
                                atom.set(fieldName, list);
                            }
                            list.add(mapValue);
                        }
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        Collection collectionValue = (Collection)FieldInfo.getFieldValue((Field)field, (Object)destination);
                        if (collectionValue == null) {
                            collectionValue = ClassInfo.newCollectionInstance(fieldClass);
                            FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)collectionValue);
                        }
                        Object elementValue = null;
                        Class subFieldClass = ClassInfo.getCollectionParameter((Field)field);
                        if (subFieldClass == null || FieldInfo.isPrimitive((Class)subFieldClass)) {
                            int level = 1;
                            while (level != 0) {
                                switch (parser.next()) {
                                    case 1: {
                                        return true;
                                    }
                                    case 2: {
                                        ++level;
                                        break;
                                    }
                                    case 3: {
                                        --level;
                                        break;
                                    }
                                    case 4: {
                                        if (level != 1 || subFieldClass == null) break;
                                        elementValue = Xml.parseValue(parser.getText(), subFieldClass);
                                    }
                                }
                            }
                        } else {
                            elementValue = ClassInfo.newInstance((Class)subFieldClass);
                            isStopped = Xml.parseElementInternal(parser, elementValue, namespaceDictionary, customizeParser);
                        }
                        collectionValue.add(elementValue);
                    } else {
                        Object value = ClassInfo.newInstance(fieldClass);
                        isStopped = Xml.parseElementInternal(parser, value, namespaceDictionary, customizeParser);
                        FieldInfo.setFieldValue((Field)field, (Object)destination, (Object)value);
                    }
                    if (!isStopped) break;
                    return true;
                }
            }
        }
    }

    private static String getFieldName(boolean isAttribute, String alias, String namespace, String name) {
        alias = alias == null ? "" : alias;
        StringBuilder buf = new StringBuilder(2 + alias.length() + name.length());
        if (isAttribute) {
            buf.append('@');
        }
        if (alias != "") {
            buf.append(alias).append(':');
        }
        return buf.append(name).toString();
    }

    private static Object parseValue(String stringValue, Class<?> fieldClass) {
        if (fieldClass == Double.class || fieldClass == Double.TYPE) {
            if (stringValue.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (stringValue.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
        }
        if (fieldClass == Float.class || fieldClass == Float.TYPE) {
            if (stringValue.equals("INF")) {
                return Float.valueOf(Float.POSITIVE_INFINITY);
            }
            if (stringValue.equals("-INF")) {
                return Float.valueOf(Float.NEGATIVE_INFINITY);
            }
        }
        return FieldInfo.parsePrimitiveValue(fieldClass, (String)stringValue);
    }

    private Xml() {
    }

    public static class CustomizeParser {
        public boolean stopBeforeStartTag(String namespace, String localName) {
            return false;
        }

        public boolean stopAfterEndTag(String namespace, String localName) {
            return false;
        }
    }
}

