/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.FakeApiClock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.threeten.bp.Duration;

public abstract class RecordingScheduler
implements ScheduledExecutorService {
    public abstract List<Duration> getSleepDurations();

    public abstract int getIterationsCount();

    public static RecordingScheduler create(final FakeApiClock clock) {
        RecordingScheduler mock = (RecordingScheduler)Mockito.mock(RecordingScheduler.class);
        final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
        final ArrayList sleepDurations = new ArrayList();
        final AtomicInteger iterationsCount = new AtomicInteger(0);
        Mockito.when(mock.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).then(new Answer<ScheduledFuture<?>>(){

            public ScheduledFuture<?> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                Runnable runnable = (Runnable)args[0];
                Long delay = (Long)args[1];
                TimeUnit unit = (TimeUnit)((Object)args[2]);
                iterationsCount.incrementAndGet();
                sleepDurations.add(Duration.ofMillis(TimeUnit.MILLISECONDS.convert(delay, unit)));
                clock.incrementNanoTime(TimeUnit.NANOSECONDS.convert(delay, unit));
                return executor.schedule(runnable, 0L, TimeUnit.NANOSECONDS);
            }
        });
        Mockito.when(mock.shutdownNow()).then((Answer)new Answer<List<Runnable>>(){

            public List<Runnable> answer(InvocationOnMock invocation) throws Throwable {
                return executor.shutdownNow();
            }
        });
        Mockito.when(mock.getSleepDurations()).thenReturn(sleepDurations);
        Mockito.when((Object)mock.getIterationsCount()).then((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return iterationsCount.get();
            }
        });
        return mock;
    }
}

