/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BidiStreamingCallable;
import com.google.api.gax.rpc.Callables;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ClientStreamingCallable;
import com.google.api.gax.rpc.LongRunningClient;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeExceptionCallable;

@InternalApi(value="for testing")
public class FakeCallableFactory {
    private FakeCallableFactory() {
    }

    private static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable callable = new FakeExceptionCallable<RequestT, ResponseT>(innerCallable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, clientContext);
        return callable;
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = FakeCallableFactory.createBaseUnaryCallable(innerCallable, callSettings, clientContext);
        return callable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, ResponseT> createUnpagedCallable(UnaryCallable<RequestT, ResponseT> innerCallable, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = FakeCallableFactory.createBaseUnaryCallable(innerCallable, pagedCallSettings, clientContext);
        return callable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(UnaryCallable<RequestT, ResponseT> innerCallable, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = FakeCallableFactory.createBaseUnaryCallable(innerCallable, pagedCallSettings, clientContext);
        UnaryCallable<RequestT, PagedListResponseT> pagedCallable = Callables.paged(callable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(UnaryCallable<RequestT, ResponseT> innerCallable, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = FakeCallableFactory.createBaseUnaryCallable(innerCallable, batchingCallSettings, clientContext);
        callable = Callables.batching(callable, batchingCallSettings, clientContext);
        return callable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT, MetadataT> OperationCallable<RequestT, ResponseT, MetadataT> createOperationCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings, ClientContext clientContext, LongRunningClient longRunningClient) {
        UnaryCallable<RequestT, OperationSnapshot> initialCallable = FakeCallableFactory.createBaseUnaryCallable(innerCallable, operationCallSettings.getInitialCallSettings(), clientContext);
        OperationCallable<RequestT, ResponseT, MetadataT> operationCallable = Callables.longRunningOperation(initialCallable, operationCallSettings, clientContext, longRunningClient);
        return operationCallable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT> BidiStreamingCallable<RequestT, ResponseT> createBidiStreamingCallable(BidiStreamingCallable<RequestT, ResponseT> innerCallable, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        return innerCallable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT> ServerStreamingCallable<RequestT, ResponseT> createServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> innerCallable, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        return innerCallable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }

    public static <RequestT, ResponseT> ClientStreamingCallable<RequestT, ResponseT> createClientStreamingCallable(ClientStreamingCallable<RequestT, ResponseT> innerCallable, StreamingCallSettings<RequestT, ResponseT> streamingCallSettings, ClientContext clientContext) {
        return innerCallable.withDefaultCallContext(FakeCallContext.create(clientContext));
    }
}

