/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.testing;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.testing.FakeCallContext;
import com.google.api.gax.rpc.testing.FakeChannel;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@InternalApi(value="for testing")
public class FakeTransportChannel
implements TransportChannel {
    private final FakeChannel channel;
    private volatile boolean isShutdown = false;
    private volatile Map<String, String> headers;
    private volatile Executor executor;

    private FakeTransportChannel(FakeChannel channel) {
        this.channel = channel;
    }

    public static FakeTransportChannel create(FakeChannel channel) {
        return new FakeTransportChannel(channel);
    }

    public static String getFakeTransportName() {
        return "fake";
    }

    @Override
    public String getTransportName() {
        return FakeTransportChannel.getFakeTransportName();
    }

    @Override
    public FakeCallContext getEmptyCallContext() {
        return FakeCallContext.createDefault();
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown;
    }

    @Override
    public void shutdownNow() {
        this.isShutdown = true;
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return false;
    }

    @Override
    public void close() {
    }

    public FakeChannel getChannel() {
        return this.channel;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

