/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_IfStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;

@AutoValue
public abstract class IfStatement
implements Statement {
    public abstract Expr conditionExpr();

    public abstract ImmutableList<Statement> body();

    public abstract ImmutableMap<Expr, List<Statement>> elseIfs();

    public abstract ImmutableList<Statement> elseBody();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_IfStatement.Builder().setElseIfs(ImmutableMap.of()).setElseBody(Collections.emptyList());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setConditionExpr(Expr var1);

        public abstract Builder setBody(List<Statement> var1);

        public abstract Builder setElseBody(List<Statement> var1);

        public Builder addElseIf(Expr conditionExpr, List<Statement> body) {
            this.elseIfsBuilder().put(conditionExpr, body);
            return this;
        }

        abstract ImmutableMap.Builder<Expr, List<Statement>> elseIfsBuilder();

        abstract Builder setElseIfs(ImmutableMap<Expr, List<Statement>> var1);

        abstract IfStatement autoBuild();

        public IfStatement build() {
            IfStatement ifStatement = this.autoBuild();
            NodeValidator.checkNoNullElements(ifStatement.body(), "body", "if-statement");
            NodeValidator.checkNoNullElements(ifStatement.elseIfs(), "else-ifs", "if-statement");
            NodeValidator.checkNoNullElements(ifStatement.elseBody(), "else-body", "if-statement");
            Preconditions.checkState(ifStatement.conditionExpr().type().equals(TypeNode.BOOLEAN), "If-condition must be a boolean-typed expression");
            return ifStatement;
        }
    }
}

