/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_LogicalOperationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class LogicalOperationExpr
implements OperationExpr {
    public abstract Expr lhsExpr();

    public abstract Expr rhsExpr();

    @Override
    public abstract OperatorKind operatorKind();

    @Override
    public TypeNode type() {
        return TypeNode.BOOLEAN;
    }

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static LogicalOperationExpr logicalAndWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return LogicalOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.LOGICAL_AND).build();
    }

    public static LogicalOperationExpr logicalOrWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return LogicalOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.LOGICAL_OR).build();
    }

    private static Builder builder() {
        return new AutoValue_LogicalOperationExpr.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLhsExpr(Expr var1);

        abstract Builder setRhsExpr(Expr var1);

        abstract Builder setOperatorKind(OperatorKind var1);

        abstract LogicalOperationExpr autoBuild();

        private LogicalOperationExpr build() {
            LogicalOperationExpr logicalOperationExpr = this.autoBuild();
            TypeNode lhsExprType = logicalOperationExpr.lhsExpr().type();
            TypeNode rhsExprType = logicalOperationExpr.rhsExpr().type();
            OperatorKind operator = logicalOperationExpr.operatorKind();
            String errorMsg = String.format("Logical operator %s is valid only on boolean or its boxed type, found %s, %s.", new Object[]{operator, lhsExprType.toString(), rhsExprType.toString()});
            Preconditions.checkState(lhsExprType.equals(TypeNode.BOOLEAN) && rhsExprType.equals(TypeNode.BOOLEAN), errorMsg);
            return logicalOperationExpr;
        }
    }
}

