/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AstNode;
import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_MethodDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.IdentifierNode;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class MethodDefinition
implements AstNode {
    static final Reference RUNTIME_EXCEPTION_REFERENCE = ConcreteReference.withClazz(RuntimeException.class);

    public abstract ScopeNode scope();

    public abstract TypeNode returnType();

    public abstract IdentifierNode methodIdentifier();

    public abstract ImmutableList<CommentStatement> headerCommentStatements();

    public abstract ImmutableList<AnnotationNode> annotations();

    public abstract ImmutableList<TypeNode> throwsExceptions();

    public abstract ImmutableList<VariableExpr> arguments();

    public abstract boolean isStatic();

    public abstract boolean isFinal();

    public abstract boolean isAbstract();

    public abstract boolean isConstructor();

    public abstract ImmutableList<Statement> body();

    public abstract ImmutableList<IdentifierNode> templateIdentifiers();

    public abstract ImmutableList<IdentifierNode> returnTemplateIdentifiers();

    abstract ImmutableList<String> templateNames();

    abstract ImmutableList<String> returnTemplateNames();

    @Nullable
    public abstract ReturnExpr returnExpr();

    abstract boolean isOverride();

    @Nullable
    abstract String name();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_MethodDefinition.Builder().setArguments(Collections.emptyList()).setIsAbstract(false).setIsFinal(false).setIsStatic(false).setIsConstructor(false).setHeaderCommentStatements(Collections.emptyList()).setAnnotations(Collections.emptyList()).setThrowsExceptions(Collections.emptyList()).setBody(Collections.emptyList()).setIsOverride(false).setTemplateNames(ImmutableList.of()).setReturnTemplateNames(ImmutableList.of());
    }

    public static Builder constructorBuilder() {
        return new AutoValue_MethodDefinition.Builder().setArguments(Collections.emptyList()).setIsAbstract(false).setIsFinal(false).setIsStatic(false).setIsConstructor(true).setHeaderCommentStatements(Collections.emptyList()).setAnnotations(Collections.emptyList()).setThrowsExceptions(Collections.emptyList()).setBody(Collections.emptyList()).setIsOverride(false).setTemplateNames(ImmutableList.of()).setReturnTemplateNames(ImmutableList.of());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setScope(ScopeNode var1);

        public abstract Builder setReturnType(TypeNode var1);

        public abstract Builder setName(String var1);

        public Builder setHeaderCommentStatements(CommentStatement ... comments) {
            return this.setHeaderCommentStatements(Arrays.asList(comments));
        }

        public abstract Builder setHeaderCommentStatements(List<CommentStatement> var1);

        public abstract Builder setAnnotations(List<AnnotationNode> var1);

        public abstract Builder setIsStatic(boolean var1);

        public abstract Builder setIsFinal(boolean var1);

        public abstract Builder setIsAbstract(boolean var1);

        public abstract Builder setIsConstructor(boolean var1);

        public abstract Builder setThrowsExceptions(List<TypeNode> var1);

        public Builder setArguments(VariableExpr ... arguments) {
            return this.setArguments(Arrays.asList(arguments));
        }

        public abstract Builder setArguments(List<VariableExpr> var1);

        public abstract Builder setBody(List<Statement> var1);

        public Builder setReturnExpr(Expr expr) {
            return this.setReturnExpr(ReturnExpr.withExpr(expr));
        }

        public abstract Builder setReturnExpr(ReturnExpr var1);

        public abstract Builder setIsOverride(boolean var1);

        public abstract Builder setTemplateNames(List<String> var1);

        public abstract Builder setReturnTemplateNames(List<String> var1);

        abstract Builder setTemplateIdentifiers(List<IdentifierNode> var1);

        abstract Builder setReturnTemplateIdentifiers(List<IdentifierNode> var1);

        abstract Builder setMethodIdentifier(IdentifierNode var1);

        abstract String name();

        abstract ImmutableList<VariableExpr> arguments();

        abstract ImmutableList<CommentStatement> headerCommentStatements();

        abstract ImmutableList<AnnotationNode> annotations();

        abstract ImmutableList<TypeNode> throwsExceptions();

        abstract TypeNode returnType();

        abstract boolean isOverride();

        abstract boolean isAbstract();

        abstract boolean isFinal();

        abstract boolean isStatic();

        abstract ImmutableList<Statement> body();

        abstract boolean isConstructor();

        abstract ScopeNode scope();

        abstract MethodDefinition autoBuild();

        abstract ImmutableList<String> templateNames();

        abstract ImmutableList<String> returnTemplateNames();

        public MethodDefinition build() {
            this.performNullChecks();
            this.setTemplateIdentifiers(this.templateNames().stream().map(n -> IdentifierNode.withName(n)).collect(Collectors.toList()));
            if (!this.returnTemplateNames().isEmpty()) {
                Preconditions.checkState(TypeNode.isReferenceType(this.returnType()), "Primitive return types cannot be templated");
            }
            this.setReturnTemplateIdentifiers(this.returnTemplateNames().stream().map(n -> {
                Preconditions.checkState(this.templateNames().contains(n), String.format("Return template name %s not found in method template names", n));
                return IdentifierNode.withName(n);
            }).collect(Collectors.toList()));
            if (this.isConstructor()) {
                Preconditions.checkState(TypeNode.isReferenceType(this.returnType()), "Constructor must return an object type.");
                this.setName(this.returnType().reference().name());
            } else {
                Preconditions.checkNotNull(this.name(), "Methods must have a name");
            }
            IdentifierNode methodIdentifier = IdentifierNode.builder().setName(this.name()).build();
            this.setMethodIdentifier(methodIdentifier);
            if (this.isAbstract()) {
                Preconditions.checkState(!this.isFinal() && !this.isStatic() && !this.scope().equals(ScopeNode.PRIVATE), "Abstract methods cannot be static, final, or private");
            }
            ImmutableCollection processedAnnotations = this.annotations();
            if (this.isOverride()) {
                processedAnnotations = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.annotations())).add(AnnotationNode.OVERRIDE)).build();
            }
            this.setAnnotations(new LinkedHashSet<AnnotationNode>(processedAnnotations).stream().collect(Collectors.toList()));
            MethodDefinition method = this.autoBuild();
            Preconditions.checkState(!method.scope().equals(ScopeNode.LOCAL), "Method scope must be either public, protected, or private");
            Preconditions.checkState(!method.returnType().equals(TypeNode.NULL), "Null is not a valid method return type");
            if (method.isConstructor()) {
                Preconditions.checkState(!method.isFinal() && !method.isStatic(), "Constructors cannot be static or final");
                Preconditions.checkState(!method.isOverride(), "A constructor cannot override another");
                Preconditions.checkState(method.returnExpr() == null, "A constructor cannot have a return expression");
                Preconditions.checkState(method.returnType().reference().generics().isEmpty(), "Constructors for templated classes are not yet supported");
            } else {
                Statement lastStatement;
                boolean isLastStatementThrowExpr = false;
                if (!this.body().isEmpty() && (lastStatement = (Statement)this.body().get(this.body().size() - 1)) instanceof ExprStatement) {
                    isLastStatementThrowExpr = ((ExprStatement)lastStatement).expression() instanceof ThrowExpr;
                }
                if (!method.returnType().equals(TypeNode.VOID) && !isLastStatementThrowExpr) {
                    Preconditions.checkNotNull(method.returnExpr(), "Method with non-void return type must have a return expression");
                }
                if (!method.returnType().equals(TypeNode.VOID) && !isLastStatementThrowExpr) {
                    Preconditions.checkNotNull(method.returnExpr(), "Method with non-void return type must have a return expression");
                }
                if (method.returnExpr() != null && !isLastStatementThrowExpr) {
                    if (method.returnType().isPrimitiveType() || method.returnExpr().expr().type().isPrimitiveType()) {
                        Preconditions.checkState(method.returnType().equals(method.returnExpr().expr().type()), "Method return type does not match the return expression type");
                    } else {
                        Preconditions.checkState(method.returnType().isSupertypeOrEquals(method.returnExpr().expr().type()), "Method reference return type is not a supertype of the return expression type");
                    }
                }
            }
            this.performArgumentChecks();
            this.performThrownExceptionChecks();
            return method;
        }

        private void performArgumentChecks() {
            this.arguments().stream().forEach(varExpr -> Preconditions.checkState(varExpr.isDecl(), String.format("Argument %s must be a variable declaration", varExpr.variable().identifier())));
            this.arguments().stream().forEach(varExpr -> Preconditions.checkState(varExpr.scope().equals(ScopeNode.LOCAL) && !varExpr.isStatic() && !varExpr.isVolatile(), String.format("Argument %s must have local scope, and cannot have \"static\" or \"volatile\" modifiers", varExpr.variable().identifier())));
            List allArgNames = this.arguments().stream().map(v -> v.variable().identifier().name()).collect(Collectors.toList());
            Set duplicateArgNames = allArgNames.stream().filter(n -> Collections.frequency(allArgNames, n) > 1).collect(Collectors.toSet());
            Preconditions.checkState(duplicateArgNames.isEmpty(), String.format("Lambda arguments cannot have duplicate names: %s", duplicateArgNames.toString()));
        }

        private void performThrownExceptionChecks() {
            this.throwsExceptions().stream().forEach(exceptionType -> {
                Preconditions.checkState(TypeNode.isExceptionType(exceptionType), String.format("Type %s is not an exception type", exceptionType.reference()));
                Preconditions.checkState(!RUNTIME_EXCEPTION_REFERENCE.isAssignableFrom(exceptionType.reference()), String.format("RuntimeException type %s does not need to be thrown", exceptionType.reference().name()));
            });
        }

        private void performNullChecks() {
            String contextInfo = String.format("method definition of %s", this.name());
            NodeValidator.checkNoNullElements(this.headerCommentStatements(), "header comments", contextInfo);
            NodeValidator.checkNoNullElements(this.annotations(), "annotations", contextInfo);
            NodeValidator.checkNoNullElements(this.throwsExceptions(), "declared exceptions", contextInfo);
            NodeValidator.checkNoNullElements(this.body(), "body", contextInfo);
            NodeValidator.checkNoNullElements(this.templateNames(), "template names", contextInfo);
            NodeValidator.checkNoNullElements(this.returnTemplateNames(), "return template names", contextInfo);
        }
    }
}

