/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_WhileStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.NodeValidator;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AutoValue
public abstract class WhileStatement
implements Statement {
    public abstract Expr conditionExpr();

    public abstract ImmutableList<Statement> body();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static Builder builder() {
        return new AutoValue_WhileStatement.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setConditionExpr(Expr var1);

        public abstract Builder setBody(List<Statement> var1);

        abstract ImmutableList<Statement> body();

        abstract WhileStatement autoBuild();

        public WhileStatement build() {
            WhileStatement whileStatement = this.autoBuild();
            NodeValidator.checkNoNullElements(this.body(), "body", "while statement");
            Preconditions.checkState(whileStatement.conditionExpr().type().equals(TypeNode.BOOLEAN), "While condition must be a boolean-typed expression");
            return whileStatement;
        }
    }
}

