/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.common;

import com.google.api.MonitoredResourceDescriptor;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.batching.FlowController;
import com.google.api.gax.batching.PartitionKey;
import com.google.api.gax.batching.RequestBuilder;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.BatchedRequestIssuer;
import com.google.api.gax.rpc.BatchingCallSettings;
import com.google.api.gax.rpc.BatchingDescriptor;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AnonymousClassExpr;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.CastExpr;
import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EmptyLineStatement;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.IfStatement;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.ReferenceConstructorExpr;
import com.google.api.generator.engine.ast.RelationalOperationExpr;
import com.google.api.generator.engine.ast.ReturnExpr;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.SuperObjectValue;
import com.google.api.generator.engine.ast.TernaryExpr;
import com.google.api.generator.engine.ast.ThisObjectValue;
import com.google.api.generator.engine.ast.ThrowExpr;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.comment.SettingsCommentComposer;
import com.google.api.generator.gapic.composer.common.BatchingDescriptorComposer;
import com.google.api.generator.gapic.composer.common.ClassComposer;
import com.google.api.generator.gapic.composer.common.RetrySettingsComposer;
import com.google.api.generator.gapic.composer.common.TransportContext;
import com.google.api.generator.gapic.composer.samplecode.SampleCodeWriter;
import com.google.api.generator.gapic.composer.samplecode.SampleComposerUtil;
import com.google.api.generator.gapic.composer.samplecode.SettingsSampleComposer;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.composer.utils.PackageChecker;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicBatchingSettings;
import com.google.api.generator.gapic.model.GapicClass;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.Sample;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import org.threeten.bp.Duration;

public abstract class AbstractServiceStubSettingsClassComposer
implements ClassComposer {
    private static final Statement EMPTY_LINE_STATEMENT = EmptyLineStatement.create();
    private static final String BATCHING_DESC_PATTERN = "%s_BATCHING_DESC";
    private static final String PAGE_STR_DESC_PATTERN = "%s_PAGE_STR_DESC";
    private static final String PAGED_RESPONSE_FACTORY_PATTERN = "%s_PAGE_STR_FACT";
    private static final String PAGED_RESPONSE_TYPE_NAME_PATTERN = "%sPagedResponse";
    private static final String NESTED_BUILDER_CLASS_NAME = "Builder";
    private static final String NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_NAME = "unaryMethodSettingsBuilders";
    private static final String NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_NAME = "RETRYABLE_CODE_DEFINITIONS";
    private static final String NESTED_RETRY_PARAM_DEFINITIONS_VAR_NAME = "RETRY_PARAM_DEFINITIONS";
    private static final String OPERATION_SETTINGS_LITERAL = "OperationSettings";
    private static final String SETTINGS_LITERAL = "Settings";
    private static final String DOT = ".";
    protected static final TypeStore FIXED_TYPESTORE = AbstractServiceStubSettingsClassComposer.createStaticTypes();
    private static final VariableExpr NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR = AbstractServiceStubSettingsClassComposer.createNestedUnaryMethodSettingsBuildersVarExpr();
    private static final VariableExpr NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_EXPR = AbstractServiceStubSettingsClassComposer.createNestedRetryableCodeDefinitionsVarExpr();
    private static final VariableExpr NESTED_RETRY_PARAM_DEFINITIONS_VAR_EXPR = AbstractServiceStubSettingsClassComposer.createNestedRetryParamDefinitionsVarExpr();
    private final TransportContext transportContext;
    protected static final VariableExpr DEFAULT_SERVICE_SCOPES_VAR_EXPR = AbstractServiceStubSettingsClassComposer.createDefaultServiceScopesVarExpr();

    protected AbstractServiceStubSettingsClassComposer(TransportContext transportContext) {
        this.transportContext = transportContext;
    }

    public TransportContext getTransportContext() {
        return this.transportContext;
    }

    @Override
    public GapicClass generate(GapicContext context, Service service) {
        GapicServiceConfig serviceConfig = context.serviceConfig();
        ImmutableMap<String, Message> messageTypes = context.messages();
        String pakkage = String.format("%s.stub", service.pakkage());
        TypeStore typeStore = this.createDynamicTypes(service, pakkage);
        ArrayList<Sample> samples = new ArrayList<Sample>();
        HashSet<String> deprecatedSettingVarNames = new HashSet<String>();
        Map<String, VariableExpr> methodSettingsMemberVarExprs = AbstractServiceStubSettingsClassComposer.createMethodSettingsClassMemberVarExprs(service, serviceConfig, typeStore, false, deprecatedSettingVarNames);
        String className = ClassNames.getServiceStubSettingsClassName(service);
        List<CommentStatement> classHeaderComments = AbstractServiceStubSettingsClassComposer.createClassHeaderComments(service, typeStore.get(className), samples);
        ClassDefinition classDef = ClassDefinition.builder().setPackageString(pakkage).setHeaderCommentStatements(classHeaderComments).setAnnotations(this.createClassAnnotations(service)).setScope(ScopeNode.PUBLIC).setName(className).setExtendsType(this.createExtendsType(service, typeStore)).setStatements(AbstractServiceStubSettingsClassComposer.createClassStatements(service, serviceConfig, methodSettingsMemberVarExprs, messageTypes, typeStore)).setMethods(this.createClassMethods(service, methodSettingsMemberVarExprs, deprecatedSettingVarNames, typeStore)).setNestedClasses(Arrays.asList(this.createNestedBuilderClass(service, serviceConfig, typeStore))).build();
        return GapicClass.create(GapicClass.Kind.STUB, classDef, SampleComposerUtil.handleDuplicateSamples(samples)).withApiShortName(service.apiShortName()).withApiVersion(service.apiVersion());
    }

    protected MethodDefinition createDefaultCredentialsProviderBuilderMethod() {
        TypeNode returnType = TypeNode.withReference(ConcreteReference.withClazz(GoogleCredentialsProvider.Builder.class));
        MethodInvocationExpr credsProviderBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("GoogleCredentialsProvider")).setMethodName("newBuilder").build();
        credsProviderBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(credsProviderBuilderExpr).setMethodName("setScopesToApply").setArguments(DEFAULT_SERVICE_SCOPES_VAR_EXPR).setReturnType(returnType).build();
        credsProviderBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(credsProviderBuilderExpr).setMethodName("setUseJwtAccessWithScope").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.BOOLEAN).setValue("true").build())).setReturnType(returnType).build();
        return MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.DEFAULT_CREDENTIALS_PROVIDER_BUILDER_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("defaultCredentialsProviderBuilder").setReturnExpr(credsProviderBuilderExpr).build();
    }

    protected List<MethodDefinition> createDefaultTransportTransportProviderBuilderMethods(Service service) {
        Iterator<Class<?>> providerClassIt = this.getTransportContext().instantiatingChannelProviderClasses().iterator();
        Iterator<Class<?>> providerBuilderClassIt = this.getTransportContext().instantiatingChannelProviderBuilderClasses().iterator();
        Iterator<String> builderNamesIt = this.getTransportContext().defaultTransportProviderBuilderNames().iterator();
        Iterator<String> transportNamesIt = this.getTransportContext().transportNames().iterator();
        ArrayList<MethodDefinition> methods = new ArrayList<MethodDefinition>();
        while (providerClassIt.hasNext() && providerBuilderClassIt.hasNext() && builderNamesIt.hasNext() && transportNamesIt.hasNext()) {
            Class<?> providerClass = providerClassIt.next();
            Class<?> providerBuilderClass = providerBuilderClassIt.next();
            String builderName = builderNamesIt.next();
            String transportName = transportNamesIt.next();
            if (!service.hasAnyEnabledMethodsForTransport(transportName)) continue;
            TypeNode returnType = TypeNode.withReference(ConcreteReference.withClazz(providerBuilderClass));
            TypeNode channelProviderType = TypeNode.withReference(ConcreteReference.withClazz(providerClass));
            MethodInvocationExpr transportChannelProviderBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(channelProviderType).setMethodName("newBuilder").setReturnType(returnType).build();
            Expr returnExpr = this.initializeTransportProviderBuilder(transportChannelProviderBuilderExpr, returnType);
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            if (!methods.isEmpty()) {
                annotations.add(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).build());
            }
            CommentStatement commentStatement = SettingsCommentComposer.DEFAULT_TRANSPORT_PROVIDER_BUILDER_METHOD_COMMENT;
            if (this.getTransportContext().transportNames().size() > 1) {
                commentStatement = new SettingsCommentComposer(transportName).getTransportProviderBuilderMethodComment();
            }
            MethodDefinition method = MethodDefinition.builder().setHeaderCommentStatements(commentStatement).setAnnotations(annotations).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName(builderName).setReturnExpr(returnExpr).build();
            methods.add(method);
        }
        return methods;
    }

    protected Expr initializeTransportProviderBuilder(MethodInvocationExpr transportChannelProviderBuilderExpr, TypeNode returnType) {
        return transportChannelProviderBuilderExpr;
    }

    protected abstract List<MethodDefinition> createApiClientHeaderProviderBuilderMethods(Service var1, TypeStore var2);

    protected MethodDefinition createApiClientHeaderProviderBuilderMethod(Service service, TypeStore typeStore, String methodName, TypeNode gaxPropertiesType, String getTokenMethodName, String getVersionMethodName) {
        TypeNode returnType = TypeNode.withReference(ConcreteReference.withClazz(ApiClientHeaderProvider.Builder.class));
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ApiClientHeaderProvider")).setMethodName("newBuilder").build();
        MethodInvocationExpr versionArgExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("GaxProperties")).setMethodName("getLibraryVersion").setArguments(VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.CLASS_OBJECT).setName("class").build()).setStaticReferenceType(typeStore.get(ClassNames.getServiceStubSettingsClassName(service))).build()).build();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName("setGeneratedLibToken").setArguments(ValueExpr.withValue(StringObjectValue.withValue("gapic")), versionArgExpr).build();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName("setTransportToken").setArguments(MethodInvocationExpr.builder().setStaticReferenceType(gaxPropertiesType).setMethodName(getTokenMethodName).build(), MethodInvocationExpr.builder().setStaticReferenceType(gaxPropertiesType).setMethodName(getVersionMethodName).build()).setReturnType(returnType).build();
        AnnotationNode annotation = AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).setDescription("The surface for customizing headers is not stable yet and may change in the future.").build();
        return MethodDefinition.builder().setAnnotations(Arrays.asList(annotation)).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName(methodName).setReturnExpr(returnExpr).build();
    }

    public abstract MethodDefinition createDefaultTransportChannelProviderMethod();

    private List<AnnotationNode> createClassAnnotations(Service service) {
        ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
        if (!PackageChecker.isGaApi(service.pakkage())) {
            annotations.add(AnnotationNode.withType(FIXED_TYPESTORE.get("BetaApi")));
        }
        if (service.isDeprecated()) {
            annotations.add(AnnotationNode.withType(TypeNode.DEPRECATED));
        }
        annotations.add(AnnotationNode.builder().setType(FIXED_TYPESTORE.get("Generated")).setDescription("by gapic-generator-java").build());
        return annotations;
    }

    private static List<CommentStatement> createClassHeaderComments(Service service, TypeNode classType, List<Sample> samples) {
        Optional<Method> methodOpt = service.methods().isEmpty() ? Optional.empty() : Optional.of(service.methods().stream().filter(m4 -> m4.stream() == Method.Stream.NONE && !m4.hasLro() && !m4.isPaged()).findFirst().orElse((Method)service.methods().get(0)));
        Optional<String> methodNameOpt = methodOpt.map(Method::name);
        Optional<Sample> sampleCode = SettingsSampleComposer.composeSettingsSample(methodNameOpt, ClassNames.getServiceSettingsClassName(service), classType);
        Optional<String> docSampleCode = Optional.empty();
        if (sampleCode.isPresent()) {
            samples.add(sampleCode.get());
            docSampleCode = Optional.of(SampleCodeWriter.writeInlineSample(sampleCode.get().body()));
        }
        return SettingsCommentComposer.createClassHeaderComments(ClassNames.getServiceStubClassName(service), service.defaultHost(), service.isDeprecated(), methodNameOpt, docSampleCode, classType);
    }

    private TypeNode createExtendsType(Service service, TypeStore typeStore) {
        TypeNode thisClassType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        return TypeNode.withReference(FIXED_TYPESTORE.get("StubSettings").reference().copyAndSetGenerics(Arrays.asList(thisClassType.reference())));
    }

    private static Map<String, VariableExpr> createMethodSettingsClassMemberVarExprs(Service service, GapicServiceConfig serviceConfig, TypeStore typeStore, boolean isNestedClass, Set<String> deprecatedSettingVarNames) {
        LinkedHashMap<String, VariableExpr> varExprs = new LinkedHashMap<String, VariableExpr>();
        for (Method method : service.methods()) {
            boolean hasBatchingSettings = !Objects.isNull(serviceConfig) && serviceConfig.hasBatchingSetting(service, method);
            TypeNode settingsType = AbstractServiceStubSettingsClassComposer.getCallSettingsType(method, typeStore, hasBatchingSettings, isNestedClass);
            String varName = String.format("%sSettings", JavaStyle.toLowerCamelCase(method.name()));
            if (method.isDeprecated()) {
                deprecatedSettingVarNames.add(varName);
            }
            varExprs.put(varName, VariableExpr.withVariable(Variable.builder().setType(settingsType).setName(varName).build()));
            if (!method.hasLro()) continue;
            settingsType = AbstractServiceStubSettingsClassComposer.getOperationCallSettingsType(method, isNestedClass);
            varName = JavaStyle.toLowerCamelCase(String.format("%sOperationSettings", method.name()));
            varExprs.put(varName, VariableExpr.withVariable(Variable.builder().setType(settingsType).setName(varName).build()));
        }
        return varExprs;
    }

    private static List<Statement> createClassStatements(Service service, GapicServiceConfig serviceConfig, Map<String, VariableExpr> methodSettingsMemberVarExprs, Map<String, Message> messageTypes, TypeStore typeStore) {
        Function<Expr, Statement> exprToStatementFn = e -> ExprStatement.withExpr(e);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(SettingsCommentComposer.DEFAULT_SCOPES_COMMENT);
        VariableExpr defaultServiceScopesDeclVarExpr = DEFAULT_SERVICE_SCOPES_VAR_EXPR.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build();
        MethodInvocationExpr listBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ImmutableList")).setGenerics(Arrays.asList(ConcreteReference.withClazz(String.class))).setMethodName("builder").build();
        for (String serviceScope : service.oauthScopes()) {
            listBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(listBuilderExpr).setMethodName("add").setArguments(ValueExpr.withValue(StringObjectValue.withValue(serviceScope))).build();
        }
        listBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(listBuilderExpr).setMethodName("build").setReturnType(DEFAULT_SERVICE_SCOPES_VAR_EXPR.type()).build();
        statements.add(exprToStatementFn.apply(AssignmentExpr.builder().setVariableExpr(defaultServiceScopesDeclVarExpr).setValueExpr(listBuilderExpr).build()));
        statements.addAll(methodSettingsMemberVarExprs.values().stream().map(v -> (Statement)exprToStatementFn.apply(v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsFinal(true).build())).collect(Collectors.toList()));
        statements.add(EMPTY_LINE_STATEMENT);
        for (Expr pagingAssignExpr : AbstractServiceStubSettingsClassComposer.createPagingStaticAssignExprs(service, serviceConfig, messageTypes, typeStore)) {
            statements.add(exprToStatementFn.apply(pagingAssignExpr));
            statements.add(EMPTY_LINE_STATEMENT);
        }
        for (Method method : service.methods()) {
            Optional batchingSettingOpt;
            Optional<Object> optional = batchingSettingOpt = Objects.isNull(serviceConfig) ? Optional.empty() : serviceConfig.getBatchingSetting(service, method);
            if (batchingSettingOpt.isPresent()) {
                statements.add(exprToStatementFn.apply(BatchingDescriptorComposer.createBatchingDescriptorFieldDeclExpr(method, (GapicBatchingSettings)batchingSettingOpt.get(), messageTypes)));
            }
            statements.add(EMPTY_LINE_STATEMENT);
        }
        return statements;
    }

    private static List<Expr> createPagingStaticAssignExprs(Service service, GapicServiceConfig serviceConfig, Map<String, Message> messageTypes, TypeStore typeStore) {
        ArrayList<Expr> descExprs = new ArrayList<Expr>();
        ArrayList<Expr> factoryExprs = new ArrayList<Expr>();
        for (Method method : service.methods()) {
            if (!method.isPaged()) continue;
            String pagedResponseMessageKey = method.outputType().reference().fullName();
            if (method.hasLro()) {
                pagedResponseMessageKey = method.lro().responseType().reference().fullName();
            }
            Message pagedResponseMessage = messageTypes.get(pagedResponseMessageKey);
            Preconditions.checkNotNull(pagedResponseMessage, String.format("No method found for message type %s for method %s among %s", pagedResponseMessageKey, method.name(), messageTypes.keySet()));
            Field repeatedPagedResultsField = pagedResponseMessage.findAndUnwrapPaginatedRepeatedField();
            Preconditions.checkNotNull(repeatedPagedResultsField, String.format("No repeated type found for paged reesponse %s for method %s", method.outputType().reference().name(), method.name()));
            TypeNode repeatedResponseType = repeatedPagedResultsField.type();
            String repeatedFieldName = repeatedPagedResultsField.name();
            TypeNode pagedListDescType = TypeNode.withReference(ConcreteReference.builder().setClazz(PagedListDescriptor.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
            String pageStrDescVarName = String.format(PAGE_STR_DESC_PATTERN, JavaStyle.toUpperSnakeCase(method.name()));
            VariableExpr pagedListDescVarExpr = VariableExpr.withVariable(Variable.builder().setType(pagedListDescType).setName(pageStrDescVarName).build());
            descExprs.add(AbstractServiceStubSettingsClassComposer.createPagedListDescriptorAssignExpr(pagedListDescVarExpr, method, repeatedResponseType, repeatedFieldName, messageTypes, typeStore));
            factoryExprs.add(AbstractServiceStubSettingsClassComposer.createPagedListResponseFactoryAssignExpr(pagedListDescVarExpr, method, repeatedResponseType, typeStore));
        }
        descExprs.addAll(factoryExprs);
        return descExprs;
    }

    private static Expr createPagedListDescriptorAssignExpr(VariableExpr pagedListDescVarExpr, Method method, TypeNode repeatedResponseType, String repeatedFieldName, Map<String, Message> messageTypes, TypeStore typeStore) {
        MethodInvocationExpr elseExpr;
        MethodInvocationExpr thenExpr;
        MethodInvocationExpr getResponsesExpr;
        MethodDefinition.Builder methodStarterBuilder = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC);
        ArrayList<MethodDefinition> anonClassMethods = new ArrayList<MethodDefinition>();
        anonClassMethods.add(methodStarterBuilder.setReturnType(TypeNode.STRING).setName("emptyToken").setReturnExpr(ValueExpr.withValue(StringObjectValue.withValue(""))).build());
        VariableExpr payloadVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("payload").build());
        VariableExpr strTokenVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.STRING).setName("token").build());
        TypeNode returnType = method.inputType();
        MethodInvocationExpr newBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(method.inputType()).setMethodName("newBuilder").setArguments(payloadVarExpr).build();
        Expr returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(newBuilderExpr).setMethodName("setPageToken").setArguments(strTokenVarExpr).build();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName("build").setReturnType(returnType).build();
        anonClassMethods.add(methodStarterBuilder.setReturnType(method.inputType()).setName("injectToken").setArguments(Arrays.asList(payloadVarExpr, strTokenVarExpr).stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setReturnExpr(returnExpr).build());
        VariableExpr pageSizeVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.INT).setName("pageSize").build());
        returnType = method.inputType();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(newBuilderExpr).setMethodName("set" + JavaStyle.toUpperCamelCase(method.pageSizeFieldName())).setArguments(pageSizeVarExpr).build();
        returnExpr = MethodInvocationExpr.builder().setExprReferenceExpr(returnExpr).setMethodName("build").setReturnType(returnType).build();
        anonClassMethods.add(methodStarterBuilder.setReturnType(method.inputType()).setName("injectPageSize").setArguments(Arrays.asList(payloadVarExpr, pageSizeVarExpr).stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setReturnExpr(returnExpr).build());
        returnType = TypeNode.INT_OBJECT;
        anonClassMethods.add(methodStarterBuilder.setReturnType(returnType).setName("extractPageSize").setArguments(payloadVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(payloadVarExpr).setMethodName("get" + JavaStyle.toUpperCamelCase(method.pageSizeFieldName())).setReturnType(returnType).build()).build());
        returnType = TypeNode.STRING;
        payloadVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.outputType()).setName("payload").build());
        anonClassMethods.add(methodStarterBuilder.setReturnType(returnType).setName("extractNextToken").setArguments(payloadVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(MethodInvocationExpr.builder().setExprReferenceExpr(payloadVarExpr).setMethodName("getNextPageToken").setReturnType(returnType).build()).build());
        returnType = TypeNode.withReference(ConcreteReference.builder().setClazz(Iterable.class).setGenerics(Arrays.asList(repeatedResponseType.reference())).build());
        if (repeatedResponseType.reference() != null && "java.util.Map.Entry".equals(repeatedResponseType.reference().fullName())) {
            getResponsesExpr = MethodInvocationExpr.builder().setExprReferenceExpr(payloadVarExpr).setMethodName(String.format("get%sMap", JavaStyle.toUpperCamelCase(repeatedFieldName))).setReturnType(returnType).build();
            thenExpr = MethodInvocationExpr.builder().setStaticReferenceType(TypeNode.withReference(ConcreteReference.withClazz(Collections.class))).setGenerics(Arrays.asList(repeatedResponseType.reference())).setMethodName("emptySet").setReturnType(returnType).build();
            elseExpr = MethodInvocationExpr.builder().setMethodName("entrySet").setExprReferenceExpr(MethodInvocationExpr.builder().setExprReferenceExpr(payloadVarExpr).setMethodName(String.format("get%sMap", JavaStyle.toUpperCamelCase(repeatedFieldName))).build()).setReturnType(returnType).build();
        } else {
            getResponsesExpr = MethodInvocationExpr.builder().setExprReferenceExpr(payloadVarExpr).setMethodName(String.format("get%sList", JavaStyle.toUpperCamelCase(repeatedFieldName))).setReturnType(returnType).build();
            thenExpr = MethodInvocationExpr.builder().setStaticReferenceType(TypeNode.withReference(ConcreteReference.withClazz(ImmutableList.class))).setGenerics(Arrays.asList(repeatedResponseType.reference())).setMethodName("of").setReturnType(returnType).build();
            elseExpr = getResponsesExpr;
        }
        RelationalOperationExpr conditionExpr = RelationalOperationExpr.equalToWithExprs(getResponsesExpr, ValueExpr.createNullExpr());
        returnExpr = TernaryExpr.builder().setConditionExpr(conditionExpr).setThenExpr(thenExpr).setElseExpr(elseExpr).build();
        anonClassMethods.add(methodStarterBuilder.setReturnType(returnType).setName("extractResources").setArguments(payloadVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(returnExpr).build());
        AnonymousClassExpr pagedListDescAnonClassExpr = AnonymousClassExpr.builder().setType(pagedListDescVarExpr.type()).setMethods(anonClassMethods).build();
        return AssignmentExpr.builder().setVariableExpr(pagedListDescVarExpr.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build()).setValueExpr(pagedListDescAnonClassExpr).build();
    }

    private static Expr createPagedListResponseFactoryAssignExpr(VariableExpr pageStrDescVarExpr, Method method, TypeNode repeatedResponseType, TypeStore typeStore) {
        Preconditions.checkState(method.isPaged(), String.format("Method %s is not paged", method.name()));
        TypeNode pagedResponseType = typeStore.get(AbstractServiceStubSettingsClassComposer.getPagedResponseTypeName(method.name()));
        TypeNode apiFutureType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(pagedResponseType.reference())).build());
        VariableExpr callableVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(UnaryCallable.class).setGenerics(Arrays.asList(method.inputType().reference(), method.outputType().reference())).build())).setName("callable").build());
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
        VariableExpr contextVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("ApiCallContext")).setName("context").build());
        VariableExpr futureResponseVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFuture.class).setGenerics(Arrays.asList(method.outputType().reference())).build())).setName("futureResponse").build());
        TypeNode pageContextType = TypeNode.withReference(ConcreteReference.builder().setClazz(PageContext.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), repeatedResponseType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        VariableExpr pageContextVarExpr = VariableExpr.withVariable(Variable.builder().setType(pageContextType).setName("pageContext").build());
        AssignmentExpr pageContextAssignExpr = AssignmentExpr.builder().setVariableExpr(pageContextVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("PageContext")).setMethodName("create").setArguments(callableVarExpr, pageStrDescVarExpr, requestVarExpr, contextVarExpr).setReturnType(pageContextVarExpr.type()).build()).build();
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get(AbstractServiceStubSettingsClassComposer.getPagedResponseTypeName(method.name()))).setMethodName("createAsync").setArguments(pageContextVarExpr, futureResponseVarExpr).setReturnType(apiFutureType).build();
        MethodDefinition getFuturePagedResponseMethod = MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(apiFutureType).setName("getFuturePagedResponse").setArguments(Arrays.asList(callableVarExpr, requestVarExpr, contextVarExpr, futureResponseVarExpr).stream().map(v -> v.toBuilder().setIsDecl(true).build()).collect(Collectors.toList())).setBody(Arrays.asList(ExprStatement.withExpr(pageContextAssignExpr))).setReturnExpr(returnExpr).build();
        TypeNode pagedResponseFactoryType = TypeNode.withReference(ConcreteReference.builder().setClazz(PagedListResponseFactory.class).setGenerics(Arrays.asList(method.inputType(), method.outputType(), typeStore.get(AbstractServiceStubSettingsClassComposer.getPagedResponseTypeName(method.name()))).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        String varName = String.format(PAGED_RESPONSE_FACTORY_PATTERN, JavaStyle.toUpperSnakeCase(method.name()));
        VariableExpr pagedListResponseFactoryVarExpr = VariableExpr.withVariable(Variable.builder().setType(pagedResponseFactoryType).setName(varName).build());
        AnonymousClassExpr factoryAnonClassExpr = AnonymousClassExpr.builder().setType(pagedResponseFactoryType).setMethods(Arrays.asList(getFuturePagedResponseMethod)).build();
        return AssignmentExpr.builder().setVariableExpr(pagedListResponseFactoryVarExpr.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build()).setValueExpr(factoryAnonClassExpr).build();
    }

    private List<MethodDefinition> createClassMethods(Service service, Map<String, VariableExpr> methodSettingsMemberVarExprs, Set<String> deprecatedSettingVarNames, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        javaMethods.addAll(AbstractServiceStubSettingsClassComposer.createMethodSettingsGetterMethods(methodSettingsMemberVarExprs, deprecatedSettingVarNames));
        javaMethods.add(this.createCreateStubMethod(service, typeStore));
        javaMethods.addAll(this.createDefaultHelperAndGetterMethods(service, typeStore));
        javaMethods.addAll(this.createNewBuilderMethods(service, typeStore, "newBuilder", "createDefault", SettingsCommentComposer.NEW_BUILDER_METHOD_COMMENT));
        javaMethods.addAll(this.createBuilderHelperMethods(service, typeStore));
        javaMethods.add(AbstractServiceStubSettingsClassComposer.createClassConstructor(service, methodSettingsMemberVarExprs, typeStore));
        return javaMethods;
    }

    private static List<MethodDefinition> createMethodSettingsGetterMethods(Map<String, VariableExpr> methodSettingsMemberVarExprs, Set<String> deprecatedSettingVarNames) {
        Function<Map.Entry, MethodDefinition> varToMethodFn = e -> {
            boolean isDeprecated = deprecatedSettingVarNames.contains(e.getKey());
            return MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.createCallSettingsGetterComment(AbstractServiceStubSettingsClassComposer.getMethodNameFromSettingsVarName((String)e.getKey()), isDeprecated)).setAnnotations(isDeprecated ? Arrays.asList(AnnotationNode.withType(TypeNode.DEPRECATED)) : Collections.emptyList()).setScope(ScopeNode.PUBLIC).setReturnType(((VariableExpr)e.getValue()).type()).setName((String)e.getKey()).setReturnExpr((Expr)e.getValue()).build();
        };
        return methodSettingsMemberVarExprs.entrySet().stream().map(e -> (MethodDefinition)varToMethodFn.apply((Map.Entry)e)).collect(Collectors.toList());
    }

    private MethodDefinition createCreateStubMethod(Service service, TypeStore typeStore) {
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        MethodInvocationExpr getTransportNameExpr = MethodInvocationExpr.builder().setMethodName("getTransportChannelProvider").build();
        getTransportNameExpr = MethodInvocationExpr.builder().setExprReferenceExpr(getTransportNameExpr).setMethodName("getTransportName").build();
        Iterator<String> transportNamesIt = this.getTransportContext().transportNames().iterator();
        Iterator<TypeNode> channelTypesIt = this.getTransportContext().transportChannelTypes().iterator();
        Iterator<String> getterNameIt = this.getTransportContext().transportGetterNames().iterator();
        Iterator<String> serivceStubClassNameIt = this.getTransportContext().classNames().getTransportServiceStubClassNames(service).iterator();
        while (channelTypesIt.hasNext() && getterNameIt.hasNext()) {
            String transportName = transportNamesIt.next();
            TypeNode channelType = channelTypesIt.next();
            String getterName = getterNameIt.next();
            String serivceStubClassName = serivceStubClassNameIt.next();
            if (!service.hasAnyEnabledMethodsForTransport(transportName)) continue;
            MethodInvocationExpr transportNameExpr = MethodInvocationExpr.builder().setStaticReferenceType(channelType).setMethodName(getterName).build();
            MethodInvocationExpr ifConditionExpr = MethodInvocationExpr.builder().setExprReferenceExpr(getTransportNameExpr).setMethodName("equals").setArguments(transportNameExpr).setReturnType(TypeNode.BOOLEAN).build();
            MethodInvocationExpr createExpr = MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get(serivceStubClassName)).setMethodName("create").setArguments(ValueExpr.withValue(ThisObjectValue.withType(typeStore.get(ClassNames.getServiceStubSettingsClassName(service))))).build();
            IfStatement ifStatement = IfStatement.builder().setConditionExpr(ifConditionExpr).setBody(Arrays.asList(ExprStatement.withExpr(ReturnExpr.withExpr(createExpr)))).build();
            bodyStatements.add(ifStatement);
        }
        MethodInvocationExpr errorMessageExpr = MethodInvocationExpr.builder().setStaticReferenceType(TypeNode.STRING).setMethodName("format").setArguments(ValueExpr.withValue(StringObjectValue.withValue("Transport not supported: %s")), getTransportNameExpr).setReturnType(TypeNode.STRING).build();
        TypeNode exceptionType = TypeNode.withExceptionClazz(UnsupportedOperationException.class);
        ExprStatement throwStatement = ExprStatement.withExpr(ThrowExpr.builder().setType(exceptionType).setMessageExpr(errorMessageExpr).build());
        bodyStatements.add(throwStatement);
        TypeNode returnType = typeStore.get(ClassNames.getServiceStubClassName(service));
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(returnType).setName("createStub").setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(IOException.class))).setBody(bodyStatements).build();
    }

    private List<MethodDefinition> createDefaultHelperAndGetterMethods(Service service, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        TypeNode returnType = TypeNode.withReference(ConcreteReference.withClazz(InstantiatingExecutorProvider.Builder.class));
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.DEFAULT_EXECUTOR_PROVIDER_BUILDER_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("defaultExecutorProviderBuilder").setReturnExpr(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("InstantiatingExecutorProvider")).setMethodName("newBuilder").setReturnType(returnType).build()).build());
        returnType = TypeNode.STRING;
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.DEFAULT_SERVICE_ENDPOINT_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("getDefaultEndpoint").setReturnExpr(ValueExpr.withValue(StringObjectValue.withValue(service.defaultHost()))).build());
        returnType = TypeNode.STRING;
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.DEFAULT_SERVICE_MTLS_ENDPOINT_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("getDefaultMtlsEndpoint").setReturnExpr(ValueExpr.withValue(StringObjectValue.withValue(service.defaultHost().replace(".googleapis.com", ".mtls.googleapis.com")))).build());
        returnType = TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(TypeNode.STRING.reference())).build());
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.DEFAULT_SERVICE_SCOPES_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(returnType).setName("getDefaultServiceScopes").setReturnExpr(DEFAULT_SERVICE_SCOPES_VAR_EXPR).build());
        javaMethods.add(this.createDefaultCredentialsProviderBuilderMethod());
        javaMethods.addAll(this.createDefaultTransportTransportProviderBuilderMethods(service));
        javaMethods.add(this.createDefaultTransportChannelProviderMethod());
        javaMethods.addAll(this.createApiClientHeaderProviderBuilderMethods(service, typeStore));
        return javaMethods;
    }

    protected List<MethodDefinition> createNewBuilderMethods(Service service, TypeStore typeStore, String newBuilderMethodName, String createDefaultMethodName, CommentStatement methodComment) {
        TypeNode builderReturnType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        return ImmutableList.of(MethodDefinition.builder().setHeaderCommentStatements(methodComment).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(builderReturnType).setName(newBuilderMethodName).setReturnExpr(MethodInvocationExpr.builder().setStaticReferenceType(builderReturnType).setMethodName(createDefaultMethodName).setReturnType(builderReturnType).build()).build());
    }

    protected List<MethodDefinition> createBuilderHelperMethods(Service service, TypeStore typeStore) {
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        TypeNode builderReturnType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        Function<Expr, NewObjectExpr> newBuilderFn = argExpr -> NewObjectExpr.builder().setType(builderReturnType).setArguments((Expr)argExpr).build();
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("ClientContext")).setName("clientContext").build());
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.NEW_BUILDER_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(builderReturnType).setName("newBuilder").setArguments(clientContextVarExpr.toBuilder().setIsDecl(true).build()).setReturnExpr(newBuilderFn.apply(clientContextVarExpr)).build());
        javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.TO_BUILDER_METHOD_COMMENT).setScope(ScopeNode.PUBLIC).setReturnType(builderReturnType).setName("toBuilder").setReturnExpr(newBuilderFn.apply(ValueExpr.withValue(ThisObjectValue.withType(typeStore.get(ClassNames.getServiceStubClassName(service)))))).build());
        return javaMethods;
    }

    private static MethodDefinition createClassConstructor(Service service, Map<String, VariableExpr> methodSettingsMemberVarExprs, TypeStore typeStore) {
        TypeNode thisType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsBuilderVarExpr = VariableExpr.withVariable(Variable.builder().setType(typeStore.get(NESTED_BUILDER_CLASS_NAME)).setName("settingsBuilder").build());
        ReferenceConstructorExpr superCtorExpr = ReferenceConstructorExpr.superBuilder().setType(FIXED_TYPESTORE.get("StubSettings")).setArguments(settingsBuilderVarExpr).build();
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        bodyStatements.add(ExprStatement.withExpr(superCtorExpr));
        bodyStatements.add(EMPTY_LINE_STATEMENT);
        Function<Map.Entry, AssignmentExpr> varInitExprFn = e -> AssignmentExpr.builder().setVariableExpr((VariableExpr)e.getValue()).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(MethodInvocationExpr.builder().setExprReferenceExpr(settingsBuilderVarExpr).setMethodName((String)e.getKey()).build()).setMethodName("build").setReturnType(((VariableExpr)e.getValue()).type()).build()).build();
        bodyStatements.addAll(methodSettingsMemberVarExprs.entrySet().stream().map(e -> ExprStatement.withExpr((Expr)varInitExprFn.apply((Map.Entry)e))).collect(Collectors.toList()));
        return MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(thisType).setArguments(settingsBuilderVarExpr.toBuilder().setIsDecl(true).build()).setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(IOException.class))).setBody(bodyStatements).build();
    }

    private ClassDefinition createNestedBuilderClass(Service service, @Nullable GapicServiceConfig serviceConfig, TypeStore typeStore) {
        String thisClassName = ClassNames.getServiceStubSettingsClassName(service);
        String className = NESTED_BUILDER_CLASS_NAME;
        TypeNode extendsType = TypeNode.withReference(ConcreteReference.builder().setClazz(StubSettings.Builder.class).setGenerics(Arrays.asList(typeStore.get(thisClassName), typeStore.get(className)).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        HashSet<String> nestedDeprecatedSettingVarNames = new HashSet<String>();
        Map<String, VariableExpr> nestedMethodSettingsMemberVarExprs = AbstractServiceStubSettingsClassComposer.createMethodSettingsClassMemberVarExprs(service, serviceConfig, typeStore, true, nestedDeprecatedSettingVarNames);
        return ClassDefinition.builder().setIsNested(true).setHeaderCommentStatements(SettingsCommentComposer.createBuilderClassComment(ClassNames.getServiceStubSettingsClassName(service))).setScope(ScopeNode.PUBLIC).setIsStatic(true).setName(className).setExtendsType(extendsType).setStatements(AbstractServiceStubSettingsClassComposer.createNestedClassStatements(service, serviceConfig, nestedMethodSettingsMemberVarExprs)).setMethods(this.createNestedClassMethods(service, serviceConfig, extendsType, nestedMethodSettingsMemberVarExprs, nestedDeprecatedSettingVarNames, typeStore)).build();
    }

    private static List<Statement> createNestedClassStatements(Service service, GapicServiceConfig serviceConfig, Map<String, VariableExpr> nestedMethodSettingsMemberVarExprs) {
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        Function<VariableExpr, VariableExpr> varDeclFn = v -> v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsFinal(true).build();
        exprs.add(varDeclFn.apply(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR));
        exprs.addAll(nestedMethodSettingsMemberVarExprs.values().stream().map(v -> (VariableExpr)varDeclFn.apply((VariableExpr)v)).collect(Collectors.toList()));
        Function<VariableExpr, VariableExpr> varStaticDeclFn = v -> v.toBuilder().setIsDecl(true).setScope(ScopeNode.PRIVATE).setIsStatic(true).setIsFinal(true).build();
        Function<Expr, Statement> exprStatementFn = e -> ExprStatement.withExpr(e);
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.addAll(exprs.stream().map(e -> (Statement)exprStatementFn.apply((Expr)e)).collect(Collectors.toList()));
        statements.add(exprStatementFn.apply(varStaticDeclFn.apply(NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_EXPR)));
        statements.add(RetrySettingsComposer.createRetryCodesDefinitionsBlock(service, serviceConfig, NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_EXPR));
        statements.add(exprStatementFn.apply(varStaticDeclFn.apply(NESTED_RETRY_PARAM_DEFINITIONS_VAR_EXPR)));
        statements.add(RetrySettingsComposer.createRetryParamDefinitionsBlock(service, serviceConfig, NESTED_RETRY_PARAM_DEFINITIONS_VAR_EXPR));
        return statements;
    }

    private List<MethodDefinition> createNestedClassMethods(Service service, GapicServiceConfig serviceConfig, TypeNode superType, Map<String, VariableExpr> nestedMethodSettingsMemberVarExprs, Set<String> nestedDeprecatedSettingVarNames, TypeStore typeStore) {
        ArrayList<MethodDefinition> nestedClassMethods = new ArrayList<MethodDefinition>();
        nestedClassMethods.addAll(AbstractServiceStubSettingsClassComposer.createNestedClassConstructorMethods(service, serviceConfig, nestedMethodSettingsMemberVarExprs, typeStore));
        nestedClassMethods.addAll(this.createNestedClassCreateDefaultMethods(service, typeStore));
        nestedClassMethods.add(this.createNestedClassInitDefaultsMethod(service, serviceConfig, typeStore));
        nestedClassMethods.add(AbstractServiceStubSettingsClassComposer.createNestedClassApplyToAllUnaryMethodsMethod(superType, typeStore));
        nestedClassMethods.add(AbstractServiceStubSettingsClassComposer.createNestedClassUnaryMethodSettingsBuilderGetterMethod());
        nestedClassMethods.addAll(AbstractServiceStubSettingsClassComposer.createNestedClassSettingsBuilderGetterMethods(nestedMethodSettingsMemberVarExprs, nestedDeprecatedSettingVarNames));
        nestedClassMethods.add(AbstractServiceStubSettingsClassComposer.createNestedClassBuildMethod(service, typeStore));
        return nestedClassMethods;
    }

    private MethodDefinition createNestedClassInitDefaultsMethod(Service service, @Nullable GapicServiceConfig serviceConfig, TypeStore typeStore) {
        TypeNode builderType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        VariableExpr builderVarExpr = VariableExpr.withVariable(Variable.builder().setType(builderType).setName("builder").build());
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        for (Method method : service.methods()) {
            Method.Stream streamKind = method.stream();
            if (streamKind.equals((Object)Method.Stream.CLIENT) || streamKind.equals((Object)Method.Stream.BIDI)) continue;
            if (!Objects.isNull(serviceConfig) && serviceConfig.hasBatchingSetting(service, method)) {
                Optional<GapicBatchingSettings> batchingSettingOpt = serviceConfig.getBatchingSetting(service, method);
                Preconditions.checkState(batchingSettingOpt.isPresent(), String.format("No batching setting found for service %s, method %s", service.name(), method.name()));
                String settingsGetterMethodName = String.format("%sSettings", JavaStyle.toLowerCamelCase(method.name()));
                bodyStatements.add(ExprStatement.withExpr(RetrySettingsComposer.createBatchingBuilderSettingsExpr(settingsGetterMethodName, batchingSettingOpt.get(), builderVarExpr)));
                bodyStatements.add(EMPTY_LINE_STATEMENT);
            }
            bodyStatements.add(ExprStatement.withExpr(RetrySettingsComposer.createSimpleBuilderSettingsExpr(service, serviceConfig, method, builderVarExpr, NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_EXPR, NESTED_RETRY_PARAM_DEFINITIONS_VAR_EXPR)));
            bodyStatements.add(EMPTY_LINE_STATEMENT);
        }
        for (Method method : service.methods()) {
            if (!method.hasLro()) continue;
            bodyStatements.add(ExprStatement.withExpr(RetrySettingsComposer.createLroSettingsBuilderExpr(service, serviceConfig, method, builderVarExpr, NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_EXPR, NESTED_RETRY_PARAM_DEFINITIONS_VAR_EXPR, this.getTransportContext().operationResponseTransformerType(), this.getTransportContext().operationMetadataTransformerType())));
            bodyStatements.add(EMPTY_LINE_STATEMENT);
        }
        return MethodDefinition.builder().setScope(ScopeNode.PRIVATE).setIsStatic(true).setReturnType(builderType).setName("initDefaults").setArguments(builderVarExpr.toBuilder().setIsDecl(true).build()).setBody(bodyStatements).setReturnExpr(builderVarExpr).build();
    }

    private static List<MethodDefinition> createNestedClassConstructorMethods(Service service, GapicServiceConfig serviceConfig, Map<String, VariableExpr> nestedMethodSettingsMemberVarExprs, TypeStore typeStore) {
        TypeNode builderType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        ArrayList<MethodDefinition> ctorMethods = new ArrayList<MethodDefinition>();
        ctorMethods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(builderType).setBody(Arrays.asList(ExprStatement.withExpr(ReferenceConstructorExpr.thisBuilder().setType(builderType).setArguments(CastExpr.builder().setType(FIXED_TYPESTORE.get("ClientContext")).setExpr(ValueExpr.createNullExpr()).build()).build()))).build());
        VariableExpr clientContextVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("ClientContext")).setName("clientContext").build());
        ConcreteReference pagedSettingsBuilderRef = ConcreteReference.withClazz(PagedCallSettings.Builder.class);
        ConcreteReference batchingSettingsBuilderRef = ConcreteReference.withClazz(BatchingCallSettings.Builder.class);
        ConcreteReference unaryCallSettingsBuilderRef = ConcreteReference.withClazz(UnaryCallSettings.Builder.class);
        Function<TypeNode, Boolean> isUnaryCallSettingsBuilderFn = t2 -> t2.reference().copyAndSetGenerics(ImmutableList.of()).equals(unaryCallSettingsBuilderRef);
        Function<TypeNode, Boolean> isPagedCallSettingsBuilderFn = t2 -> t2.reference().copyAndSetGenerics(ImmutableList.of()).equals(pagedSettingsBuilderRef);
        Function<TypeNode, Boolean> isBatchingCallSettingsBuilderFn = t2 -> t2.reference().copyAndSetGenerics(ImmutableList.of()).equals(batchingSettingsBuilderRef);
        Function<TypeNode, TypeNode> builderToCallSettingsFn = t2 -> TypeNode.withReference(VaporReference.builder().setName(String.join((CharSequence)DOT, t2.reference().enclosingClassNames())).setPakkage(t2.reference().pakkage()).build());
        ArrayList<Statement> ctorBodyStatements = new ArrayList<Statement>();
        ctorBodyStatements.add(ExprStatement.withExpr(ReferenceConstructorExpr.superBuilder().setType(builderType).setArguments(clientContextVarExpr).build()));
        ctorBodyStatements.add(EMPTY_LINE_STATEMENT);
        ctorBodyStatements.addAll(nestedMethodSettingsMemberVarExprs.entrySet().stream().map(e -> {
            VariableExpr varExpr = (VariableExpr)e.getValue();
            TypeNode varType = varExpr.type();
            Preconditions.checkState(((String)e.getKey()).endsWith(SETTINGS_LITERAL), String.format("%s expected to end with \"Settings\"", e.getKey()));
            String methodName = AbstractServiceStubSettingsClassComposer.getMethodNameFromSettingsVarName((String)e.getKey());
            if (!((Boolean)isPagedCallSettingsBuilderFn.apply(varType)).booleanValue()) {
                if (!((Boolean)isBatchingCallSettingsBuilderFn.apply(varType)).booleanValue()) {
                    boolean isUnaryCallSettings = (Boolean)isUnaryCallSettingsBuilderFn.apply(varType);
                    AssignmentExpr builderExpr = AssignmentExpr.builder().setVariableExpr(varExpr).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType((TypeNode)builderToCallSettingsFn.apply(varExpr.type())).setMethodName(isUnaryCallSettings ? "newUnaryCallSettingsBuilder" : "newBuilder").setReturnType(varExpr.type()).build()).build();
                    return ExprStatement.withExpr(builderExpr);
                }
                MethodInvocationExpr newBatchingSettingsExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("BatchingSettings")).setMethodName("newBuilder").build();
                newBatchingSettingsExpr = MethodInvocationExpr.builder().setExprReferenceExpr(newBatchingSettingsExpr).setMethodName("build").build();
                String batchingDescVarName = String.format(BATCHING_DESC_PATTERN, JavaStyle.toUpperSnakeCase(methodName));
                MethodInvocationExpr batchingSettingsBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType((TypeNode)builderToCallSettingsFn.apply(varType)).setMethodName("newBuilder").setArguments(VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("BatchingDescriptor")).setName(batchingDescVarName).build())).build();
                batchingSettingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(batchingSettingsBuilderExpr).setMethodName("setBatchingSettings").setArguments(newBatchingSettingsExpr).setReturnType(varType).build();
                AssignmentExpr builderExpr = AssignmentExpr.builder().setVariableExpr(varExpr).setValueExpr(batchingSettingsBuilderExpr).build();
                return ExprStatement.withExpr(builderExpr);
            }
            String memberVarName = String.format(PAGED_RESPONSE_FACTORY_PATTERN, JavaStyle.toUpperSnakeCase(methodName));
            VariableExpr argVar = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("PagedListResponseFactory")).setName(memberVarName).build());
            AssignmentExpr builderExpr = AssignmentExpr.builder().setVariableExpr(varExpr).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType((TypeNode)builderToCallSettingsFn.apply(varExpr.type())).setMethodName("newBuilder").setArguments(argVar).setReturnType(varExpr.type()).build()).build();
            return ExprStatement.withExpr(builderExpr);
        }).collect(Collectors.toList()));
        AssignmentExpr unaryMethodSettingsBuildersAssignExpr = AssignmentExpr.builder().setVariableExpr(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ImmutableList")).setGenerics(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR.type().reference().generics()).setMethodName("of").setArguments(nestedMethodSettingsMemberVarExprs.values().stream().filter(v -> (Boolean)isUnaryCallSettingsBuilderFn.apply(v.type()) != false || (Boolean)isPagedCallSettingsBuilderFn.apply(v.type()) != false || (Boolean)isBatchingCallSettingsBuilderFn.apply(v.type()) != false).collect(Collectors.toList())).setReturnType(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR.type()).build()).build();
        ctorBodyStatements.add(EMPTY_LINE_STATEMENT);
        ctorBodyStatements.add(ExprStatement.withExpr(unaryMethodSettingsBuildersAssignExpr));
        ctorBodyStatements.add(ExprStatement.withExpr(MethodInvocationExpr.builder().setMethodName("initDefaults").setArguments(ValueExpr.withValue(ThisObjectValue.withType(builderType))).build()));
        ctorMethods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(builderType).setArguments(clientContextVarExpr.toBuilder().setIsDecl(true).build()).setBody(ctorBodyStatements).build());
        TypeNode outerSettingsType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        VariableExpr settingsVarExpr = VariableExpr.withVariable(Variable.builder().setType(outerSettingsType).setName("settings").build());
        ctorBodyStatements = new ArrayList();
        ctorBodyStatements.add(ExprStatement.withExpr(ReferenceConstructorExpr.superBuilder().setType(builderType).setArguments(settingsVarExpr).build()));
        ctorBodyStatements.add(EMPTY_LINE_STATEMENT);
        ctorBodyStatements.addAll(nestedMethodSettingsMemberVarExprs.values().stream().map(v -> ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr((VariableExpr)v).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(VariableExpr.builder().setExprReferenceExpr(settingsVarExpr).setVariable(v.variable()).build()).setMethodName("toBuilder").setReturnType(v.type()).build()).build())).collect(Collectors.toList()));
        ctorBodyStatements.add(EMPTY_LINE_STATEMENT);
        ctorBodyStatements.add(ExprStatement.withExpr(unaryMethodSettingsBuildersAssignExpr));
        ctorMethods.add(MethodDefinition.constructorBuilder().setScope(ScopeNode.PROTECTED).setReturnType(builderType).setArguments(settingsVarExpr.toBuilder().setIsDecl(true).build()).setBody(ctorBodyStatements).build());
        return ctorMethods;
    }

    protected List<MethodDefinition> createNestedClassCreateDefaultMethods(Service service, TypeStore typeStore) {
        if (service.hasAnyEnabledMethodsForTransport(this.getTransportContext().transport())) {
            return Arrays.asList(this.createNestedClassCreateDefaultMethod(typeStore, "createDefault", "defaultTransportChannelProvider", null, "defaultApiClientHeaderProviderBuilder"));
        }
        return Collections.emptyList();
    }

    protected MethodDefinition createNestedClassCreateDefaultMethod(TypeStore typeStore, String methodName, String defaultTransportChannelProvider, String defaultTransportChannelProviderBuilder, String defaultApiClientHeaderProviderBuilder) {
        ArrayList<Statement> bodyStatements = new ArrayList<Statement>();
        TypeNode builderType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        VariableExpr builderVarExpr = VariableExpr.withVariable(Variable.builder().setType(builderType).setName("builder").build());
        bodyStatements.add(ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(builderVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(builderType).setArguments(CastExpr.builder().setType(FIXED_TYPESTORE.get("ClientContext")).setExpr(ValueExpr.createNullExpr()).build()).build()).build()));
        bodyStatements.add(EMPTY_LINE_STATEMENT);
        ArrayList<MethodInvocationExpr> bodyExprs = new ArrayList<MethodInvocationExpr>();
        if (defaultTransportChannelProvider != null) {
            bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setTransportChannelProvider").setArguments(MethodInvocationExpr.builder().setMethodName(defaultTransportChannelProvider).build()).build());
        } else {
            bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setTransportChannelProvider").setArguments(MethodInvocationExpr.builder().setExprReferenceExpr(MethodInvocationExpr.builder().setMethodName(defaultTransportChannelProviderBuilder).build()).setMethodName("build").build()).build());
        }
        bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setCredentialsProvider").setArguments(MethodInvocationExpr.builder().setExprReferenceExpr(MethodInvocationExpr.builder().setMethodName("defaultCredentialsProviderBuilder").build()).setMethodName("build").build()).build());
        bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setInternalHeaderProvider").setArguments(MethodInvocationExpr.builder().setExprReferenceExpr(MethodInvocationExpr.builder().setMethodName(defaultApiClientHeaderProviderBuilder).build()).setMethodName("build").build()).build());
        bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setEndpoint").setArguments(MethodInvocationExpr.builder().setMethodName("getDefaultEndpoint").build()).build());
        bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setMtlsEndpoint").setArguments(MethodInvocationExpr.builder().setMethodName("getDefaultMtlsEndpoint").build()).build());
        bodyExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(builderVarExpr).setMethodName("setSwitchToMtlsEndpointAllowed").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.BOOLEAN).setValue("true").build())).build());
        bodyStatements.addAll(bodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        bodyStatements.add(EMPTY_LINE_STATEMENT);
        MethodInvocationExpr returnExpr = MethodInvocationExpr.builder().setMethodName("initDefaults").setArguments(builderVarExpr).setReturnType(builderType).build();
        return MethodDefinition.builder().setScope(ScopeNode.PRIVATE).setIsStatic(true).setReturnType(builderType).setName(methodName).setBody(bodyStatements).setReturnExpr(returnExpr).build();
    }

    private static MethodDefinition createNestedClassApplyToAllUnaryMethodsMethod(TypeNode superType, TypeStore typeStore) {
        ArrayList<Reference> apiFunctionTypeGenerics = new ArrayList<Reference>();
        apiFunctionTypeGenerics.addAll(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR.type().reference().generics());
        apiFunctionTypeGenerics.add(TypeNode.VOID_OBJECT.reference());
        TypeNode settingsUpdaterType = TypeNode.withReference(ConcreteReference.builder().setClazz(ApiFunction.class).setGenerics(apiFunctionTypeGenerics).build());
        VariableExpr settingsUpdaterVarExpr = VariableExpr.withVariable(Variable.builder().setType(settingsUpdaterType).setName("settingsUpdater").build());
        String methodName = "applyToAllUnaryMethods";
        MethodInvocationExpr superApplyExpr = MethodInvocationExpr.builder().setExprReferenceExpr(ValueExpr.withValue(SuperObjectValue.withType(superType))).setMethodName(methodName).setArguments(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR, settingsUpdaterVarExpr).build();
        TypeNode returnType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        ValueExpr returnExpr = ValueExpr.withValue(ThisObjectValue.withType(returnType));
        return MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.APPLY_TO_ALL_UNARY_METHODS_METHOD_COMMENTS).setScope(ScopeNode.PUBLIC).setReturnType(returnType).setName(methodName).setArguments(settingsUpdaterVarExpr.toBuilder().setIsDecl(true).build()).setBody(Arrays.asList(ExprStatement.withExpr(superApplyExpr))).setReturnExpr(returnExpr).build();
    }

    private static MethodDefinition createNestedClassUnaryMethodSettingsBuilderGetterMethod() {
        return MethodDefinition.builder().setScope(ScopeNode.PUBLIC).setReturnType(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR.type()).setName(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_NAME).setReturnExpr(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_EXPR).build();
    }

    private static List<MethodDefinition> createNestedClassSettingsBuilderGetterMethods(Map<String, VariableExpr> nestedMethodSettingsMemberVarExprs, Set<String> nestedDeprecatedSettingVarNames) {
        ConcreteReference operationCallSettingsBuilderRef = ConcreteReference.withClazz(OperationCallSettings.Builder.class);
        Function<TypeNode, Boolean> isOperationCallSettingsBuilderFn = t2 -> t2.reference().copyAndSetGenerics(ImmutableList.of()).equals(operationCallSettingsBuilderRef);
        AnnotationNode lroBetaAnnotation = AnnotationNode.builder().setType(FIXED_TYPESTORE.get("BetaApi")).setDescription("The surface for use by generated code is not stable yet and may change in the future.").build();
        AnnotationNode deprecatedAnnotation = AnnotationNode.withType(TypeNode.DEPRECATED);
        ArrayList<MethodDefinition> javaMethods = new ArrayList<MethodDefinition>();
        for (Map.Entry<String, VariableExpr> settingsVarEntry : nestedMethodSettingsMemberVarExprs.entrySet()) {
            boolean isDeprecated;
            String varName = settingsVarEntry.getKey();
            VariableExpr settingsVarExpr = settingsVarEntry.getValue();
            boolean isOperationCallSettings = isOperationCallSettingsBuilderFn.apply(settingsVarExpr.type());
            ArrayList<AnnotationNode> annotations = new ArrayList<AnnotationNode>();
            if (isOperationCallSettings) {
                annotations.add(lroBetaAnnotation);
            }
            if (isDeprecated = nestedDeprecatedSettingVarNames.contains(varName)) {
                annotations.add(deprecatedAnnotation);
            }
            javaMethods.add(MethodDefinition.builder().setHeaderCommentStatements(SettingsCommentComposer.createCallSettingsBuilderGetterComment(AbstractServiceStubSettingsClassComposer.getMethodNameFromSettingsVarName(varName), isDeprecated)).setAnnotations(annotations).setScope(ScopeNode.PUBLIC).setReturnType(settingsVarExpr.type()).setName(settingsVarExpr.variable().identifier().name()).setReturnExpr(settingsVarExpr).build());
        }
        return javaMethods;
    }

    private static MethodDefinition createNestedClassBuildMethod(Service service, TypeStore typeStore) {
        TypeNode outerClassType = typeStore.get(ClassNames.getServiceStubSettingsClassName(service));
        TypeNode builderType = typeStore.get(NESTED_BUILDER_CLASS_NAME);
        return MethodDefinition.builder().setIsOverride(true).setScope(ScopeNode.PUBLIC).setReturnType(outerClassType).setName("build").setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(IOException.class))).setReturnExpr(NewObjectExpr.builder().setType(outerClassType).setArguments(ValueExpr.withValue(ThisObjectValue.withType(builderType))).build()).build();
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(ApiCallContext.class, ApiClientHeaderProvider.class, ApiFunction.class, ApiFuture.class, BatchedRequestIssuer.class, BatchingCallSettings.class, BatchingDescriptor.class, BatchingSettings.class, BetaApi.class, ClientContext.class, Duration.class, Empty.class, FlowControlSettings.class, GaxProperties.class, Generated.class, GoogleCredentialsProvider.class, IOException.class, ImmutableList.class, ImmutableMap.class, ImmutableSet.class, InstantiatingExecutorProvider.class, FlowController.LimitExceededBehavior.class, List.class, Lists.class, MonitoredResourceDescriptor.class, Operation.class, OperationCallSettings.class, OperationSnapshot.class, OperationTimedPollAlgorithm.class, PageContext.class, PagedCallSettings.class, PagedListDescriptor.class, PagedListResponseFactory.class, PartitionKey.class, RequestBuilder.class, RetrySettings.class, ServerStreamingCallSettings.class, StatusCode.class, StreamingCallSettings.class, StubSettings.class, TransportChannelProvider.class, UnaryCallSettings.class, UnaryCallable.class);
        return new TypeStore(concreteClazzes);
    }

    private TypeStore createDynamicTypes(Service service, String pakkage) {
        TypeStore typeStore = new TypeStore();
        String thisClassName = ClassNames.getServiceStubSettingsClassName(service);
        typeStore.putAll(pakkage, Arrays.asList(thisClassName, ClassNames.getServiceStubSettingsClassName(service), ClassNames.getServiceStubClassName(service)));
        typeStore.putAll(pakkage, this.getTransportContext().classNames().getTransportServiceStubClassNames(service));
        typeStore.put(pakkage, NESTED_BUILDER_CLASS_NAME, true, thisClassName);
        typeStore.putAll(service.pakkage(), service.methods().stream().filter(m4 -> m4.isPaged()).map(m4 -> String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, m4.name())).collect(Collectors.toList()), true, ClassNames.getServiceClientClassName(service));
        return typeStore;
    }

    private static VariableExpr createDefaultServiceScopesVarExpr() {
        TypeNode listStringType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableList.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(String.class))).build());
        return VariableExpr.withVariable(Variable.builder().setName("DEFAULT_SERVICE_SCOPES").setType(listStringType).build());
    }

    private static VariableExpr createNestedUnaryMethodSettingsBuildersVarExpr() {
        ConcreteReference builderRef = ConcreteReference.builder().setClazz(UnaryCallSettings.Builder.class).setGenerics(Arrays.asList(TypeNode.WILDCARD_REFERENCE, TypeNode.WILDCARD_REFERENCE)).build();
        TypeNode varType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableList.class).setGenerics(Arrays.asList(builderRef)).build());
        return VariableExpr.withVariable(Variable.builder().setType(varType).setName(NESTED_UNARY_METHOD_SETTINGS_BUILDERS_VAR_NAME).build());
    }

    private static VariableExpr createNestedRetryableCodeDefinitionsVarExpr() {
        TypeNode immutableSetType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableSet.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(StatusCode.Code.class))).build());
        TypeNode varType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableMap.class).setGenerics(Arrays.asList(TypeNode.STRING, immutableSetType).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        return VariableExpr.withVariable(Variable.builder().setType(varType).setName(NESTED_RETRYABLE_CODE_DEFINITIONS_VAR_NAME).build());
    }

    private static VariableExpr createNestedRetryParamDefinitionsVarExpr() {
        TypeNode varType = TypeNode.withReference(ConcreteReference.builder().setClazz(ImmutableMap.class).setGenerics(Arrays.asList(TypeNode.STRING, FIXED_TYPESTORE.get("RetrySettings")).stream().map(t2 -> t2.reference()).collect(Collectors.toList())).build());
        return VariableExpr.withVariable(Variable.builder().setType(varType).setName(NESTED_RETRY_PARAM_DEFINITIONS_VAR_NAME).build());
    }

    private static String getPagedResponseTypeName(String methodName) {
        return String.format(PAGED_RESPONSE_TYPE_NAME_PATTERN, JavaStyle.toUpperCamelCase(methodName));
    }

    private static TypeNode getCallSettingsType(Method method, TypeStore typeStore, boolean isBatchingSettings, boolean isSettingsBuilder) {
        TypeNode callSettingsType;
        Function<Class, TypeNode> typeMakerFn = clz -> TypeNode.withReference(ConcreteReference.withClazz(clz));
        TypeNode typeNode = method.isPaged() ? typeMakerFn.apply(isSettingsBuilder ? PagedCallSettings.Builder.class : PagedCallSettings.class) : (callSettingsType = typeMakerFn.apply(isSettingsBuilder ? UnaryCallSettings.Builder.class : UnaryCallSettings.class));
        if (isBatchingSettings) {
            callSettingsType = typeMakerFn.apply(isSettingsBuilder ? BatchingCallSettings.Builder.class : BatchingCallSettings.class);
        }
        switch (method.stream()) {
            case SERVER: {
                callSettingsType = typeMakerFn.apply(isSettingsBuilder ? ServerStreamingCallSettings.Builder.class : ServerStreamingCallSettings.class);
                break;
            }
            case CLIENT: 
            case BIDI: {
                callSettingsType = typeMakerFn.apply(isSettingsBuilder ? StreamingCallSettings.Builder.class : StreamingCallSettings.class);
                break;
            }
        }
        ArrayList<Reference> generics = new ArrayList<Reference>();
        generics.add(method.inputType().reference());
        generics.add(method.outputType().reference());
        if (method.isPaged()) {
            generics.add(typeStore.get(AbstractServiceStubSettingsClassComposer.getPagedResponseTypeName(method.name())).reference());
        }
        return TypeNode.withReference(callSettingsType.reference().copyAndSetGenerics(generics));
    }

    private static TypeNode getOperationCallSettingsType(Method method, boolean isSettingsBuilder) {
        Preconditions.checkState(method.hasLro(), String.format("Cannot get OperationCallSettings for non-LRO method %s", method.name()));
        ArrayList<Reference> generics = new ArrayList<Reference>();
        generics.add(method.inputType().reference());
        generics.add(method.lro().responseType().reference());
        generics.add(method.lro().metadataType().reference());
        return TypeNode.withReference(ConcreteReference.builder().setClazz(isSettingsBuilder ? OperationCallSettings.Builder.class : OperationCallSettings.class).setGenerics(generics).build());
    }

    private static String getMethodNameFromSettingsVarName(String settingsVarName) {
        BiFunction<String, String, String> methodNameSubstrFn = (s2, literal) -> s2.substring(0, s2.length() - literal.length());
        if (settingsVarName.endsWith(OPERATION_SETTINGS_LITERAL)) {
            return methodNameSubstrFn.apply(settingsVarName, OPERATION_SETTINGS_LITERAL);
        }
        if (settingsVarName.endsWith(SETTINGS_LITERAL)) {
            return methodNameSubstrFn.apply(settingsVarName, SETTINGS_LITERAL);
        }
        return settingsVarName;
    }
}

