/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.store;

import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.gapic.model.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TypeStore {
    private final Map<String, TypeNode> store = new HashMap<String, TypeNode>();

    public TypeStore() {
    }

    public TypeStore(List<Class<?>> concreteClasses) {
        this.putConcreteClassses(concreteClasses);
    }

    private void putConcreteClassses(List<Class<?>> concreteClasses) {
        this.store.putAll(concreteClasses.stream().collect(Collectors.toMap(Class::getSimpleName, c -> TypeNode.withReference(ConcreteReference.withClazz(c)))));
    }

    public TypeNode get(String typeName) {
        return this.store.get(typeName);
    }

    public void put(String pakkage, String typeName) {
        this.store.put(typeName, TypeNode.withReference(VaporReference.builder().setName(typeName).setPakkage(pakkage).build()));
    }

    public void putAll(String pakkage, List<String> typeNames) {
        for (String typeName : typeNames) {
            this.put(pakkage, typeName);
        }
    }

    public void put(String pakkage, String typeName, boolean isStaticImport, String ... enclosingClassNames) {
        this.store.put(typeName, TypeNode.withReference(VaporReference.builder().setName(typeName).setEnclosingClassNames(enclosingClassNames).setPakkage(pakkage).setIsStaticImport(isStaticImport).build()));
    }

    public void putAll(List<Class<?>> concreteClasses) {
        this.putConcreteClassses(concreteClasses);
    }

    public void putAll(String pakkage, List<String> typeNames, boolean isStaticImport, String ... enclosingClassNames) {
        for (String typeName : typeNames) {
            this.put(pakkage, typeName, isStaticImport, enclosingClassNames);
        }
    }

    public void putMessageTypes(String pakkage, Map<String, Message> messages) {
        this.store.putAll(messages.entrySet().stream().filter(e -> ((Message)e.getValue()).outerNestedTypes().isEmpty()).collect(Collectors.toMap(e -> ((Message)e.getValue()).name(), e -> TypeNode.withReference(VaporReference.builder().setName(((Message)e.getValue()).name()).setPakkage(pakkage).build()))));
    }
}

