/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.utils;

import com.google.api.generator.engine.ast.JavaDocComment;
import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommentFormatter {
    private CommentFormatter() {
    }

    public static String formatAsJavaDocComment(String comment, String prefixPattern) {
        JavaDocComment.Builder javaDocCommentBuilder = JavaDocComment.builder();
        String[] descriptionParagraphs = comment.split("\\n\\n");
        for (int i = 0; i < descriptionParagraphs.length; ++i) {
            boolean startsWithItemizedList = descriptionParagraphs[i].startsWith(" * ");
            List listItems = Stream.of(descriptionParagraphs[i].split("\\n \\*")).map(s2 -> s2.replace("\n", "")).collect(Collectors.toList());
            if (startsWithItemizedList) {
                listItems.set(0, ((String)listItems.get(0)).substring(2));
            }
            if (!startsWithItemizedList) {
                javaDocCommentBuilder = i == 0 && !Strings.isNullOrEmpty(prefixPattern) ? javaDocCommentBuilder.addParagraph(String.format(prefixPattern, listItems.get(0))) : javaDocCommentBuilder.addParagraph((String)listItems.get(0));
            }
            if (listItems.size() <= 1 && !startsWithItemizedList) continue;
            javaDocCommentBuilder = javaDocCommentBuilder.addUnorderedList(listItems.subList(startsWithItemizedList ? 0 : 1, listItems.size()));
        }
        return javaDocCommentBuilder.build().comment();
    }
}

