/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.Reference;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.VaporReference;
import com.google.api.generator.gapic.model.AutoValue_ResourceName;
import com.google.api.generator.gapic.model.HttpBindings;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.api.pathtemplate.PathTemplate;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@AutoValue
public abstract class ResourceName {
    static final String SLASH = "/";
    static final Reference RESOURCE_NAME_REF = ConcreteReference.withClazz(com.google.api.resourcenames.ResourceName.class);

    public abstract String variableName();

    public abstract String pakkage();

    public abstract String resourceTypeString();

    public abstract ImmutableList<String> patterns();

    public abstract TypeNode type();

    public abstract boolean isOnlyWildcard();

    @Nullable
    public String getMatchingPattern(HttpBindings bindings) {
        ImmutableCollection bindingPatterns = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(bindings.pattern())).addAll(bindings.additionalPatterns())).build();
        for (String bindingPattern : bindingPatterns) {
            PathTemplate bindingTemplate = PathTemplate.create(bindingPattern);
            for (String resNamePattern : this.patterns()) {
                PathTemplate restNamePatternTemplate = PathTemplate.create(resNamePattern);
                ImmutableMap.Builder<String, String> mb = ImmutableMap.builder();
                for (String string : restNamePatternTemplate.vars()) {
                    mb.put(string, string + string.hashCode() % 100);
                }
                String resNameValue = restNamePatternTemplate.instantiate(mb.build());
                mb = ImmutableMap.builder();
                for (String var3 : bindingTemplate.vars()) {
                    mb.put(var3, resNameValue);
                }
                String string = bindingTemplate.instantiate(mb.build());
                if (!bindingTemplate.matches(string)) continue;
                return resNamePattern;
            }
        }
        return null;
    }

    @Nullable
    public abstract String parentMessageName();

    @Nullable
    public abstract String description();

    public boolean hasParentMessageName() {
        return this.parentMessageName() != null;
    }

    public boolean hasDescription() {
        return this.description() != null;
    }

    public String resourceTypeName() {
        return this.resourceTypeString().substring(this.resourceTypeString().indexOf(SLASH) + 1);
    }

    public static Builder builder() {
        return new AutoValue_ResourceName.Builder().setIsOnlyWildcard(false);
    }

    public static ResourceName createWildcard(String resourceTypeString, String pakkage) {
        String placeholderVarName = JavaStyle.toLowerCamelCase(resourceTypeString.substring(resourceTypeString.indexOf(SLASH) + 1));
        return ResourceName.builder().setVariableName(placeholderVarName).setPakkage(pakkage).setResourceTypeString(resourceTypeString).setPatterns(ImmutableList.of("*")).setIsOnlyWildcard(true).setType(TypeNode.withReference(RESOURCE_NAME_REF)).build();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceName)) {
            return false;
        }
        ResourceName other = (ResourceName)o;
        return this.variableName().equals(other.variableName()) && this.pakkage().equals(other.pakkage()) && this.resourceTypeString().equals(other.resourceTypeString()) && this.patterns().equals(other.patterns()) && Objects.equals(this.parentMessageName(), other.parentMessageName()) && Objects.equals(this.type(), other.type());
    }

    public int hashCode() {
        int parentMessageNameHashCode = this.parentMessageName() == null ? 0 : this.parentMessageName().hashCode();
        int typeHashCode = this.type() == null ? 0 : this.type().hashCode();
        return 17 * this.variableName().hashCode() + 19 * this.pakkage().hashCode() + 23 * this.resourceTypeString().hashCode() + 31 * this.patterns().hashCode() + 37 * parentMessageNameHashCode + 41 * typeHashCode;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setVariableName(String var1);

        public abstract Builder setPakkage(String var1);

        public abstract Builder setResourceTypeString(String var1);

        public abstract Builder setPatterns(List<String> var1);

        public abstract Builder setParentMessageName(String var1);

        public abstract Builder setDescription(String var1);

        abstract Builder setType(TypeNode var1);

        abstract Builder setIsOnlyWildcard(boolean var1);

        abstract String pakkage();

        abstract String resourceTypeString();

        abstract boolean isOnlyWildcard();

        abstract ResourceName autoBuild();

        public ResourceName build() {
            if (!this.isOnlyWildcard()) {
                String typeName = this.resourceTypeString().substring(this.resourceTypeString().lastIndexOf(ResourceName.SLASH) + 1);
                this.setType(TypeNode.withReference(VaporReference.builder().setName(String.format("%sName", typeName)).setPakkage(this.pakkage()).setSupertypeReference(RESOURCE_NAME_REF).build()));
            }
            return this.autoBuild();
        }
    }
}

