/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.utils;

import java.util.Arrays;
import java.util.Optional;

public final class ResourceReferenceUtils {
    private static final String SLASH = "/";

    private ResourceReferenceUtils() {
    }

    public static Optional<String> parseParentPattern(String pattern) {
        String[] tokens = pattern.split(SLASH);
        String lastToken = tokens[tokens.length - 1];
        if (lastToken.equals("_deleted-topic_") || lastToken.equals("*")) {
            return Optional.empty();
        }
        int lastTokenIndex = tokens.length - 2;
        int minLengthWithParent = 4;
        if (!lastToken.contains("{")) {
            minLengthWithParent = 3;
            lastTokenIndex = tokens.length - 1;
        }
        if (tokens.length < minLengthWithParent) {
            return Optional.empty();
        }
        return Optional.of(String.join((CharSequence)SLASH, Arrays.asList(tokens).subList(0, lastTokenIndex)));
    }
}

