/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.javac.util;

import org.openjdk.tools.javac.util.Convert;
import org.openjdk.tools.javac.util.Names;

public abstract class Name
implements org.openjdk.javax.lang.model.element.Name {
    public final Table table;

    protected Name(Table table) {
        this.table = table;
    }

    @Override
    public boolean contentEquals(CharSequence charSequence) {
        return this.toString().equals(charSequence.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    public Name append(Name name) {
        int n = this.getByteLength();
        byte[] byArray = new byte[n + name.getByteLength()];
        this.getBytes(byArray, 0);
        name.getBytes(byArray, n);
        return this.table.fromUtf(byArray, 0, byArray.length);
    }

    public Name append(char c, Name name) {
        int n = this.getByteLength();
        byte[] byArray = new byte[n + 1 + name.getByteLength()];
        this.getBytes(byArray, 0);
        byArray[n] = (byte)c;
        name.getBytes(byArray, n + 1);
        return this.table.fromUtf(byArray, 0, byArray.length);
    }

    public int compareTo(Name name) {
        return name.getIndex() - this.getIndex();
    }

    @Override
    public boolean isEmpty() {
        return this.getByteLength() == 0;
    }

    public int lastIndexOf(byte by) {
        int n;
        byte[] byArray = this.getByteArray();
        int n2 = this.getByteOffset();
        for (n = this.getByteLength() - 1; n >= 0 && byArray[n2 + n] != by; --n) {
        }
        return n;
    }

    public boolean startsWith(Name name) {
        int n;
        byte[] byArray = this.getByteArray();
        int n2 = this.getByteOffset();
        int n3 = this.getByteLength();
        byte[] byArray2 = name.getByteArray();
        int n4 = name.getByteOffset();
        int n5 = name.getByteLength();
        if (n3 < n5) {
            return false;
        }
        for (n = 0; n < n5 && byArray[n2 + n] == byArray2[n4 + n]; ++n) {
        }
        return n == n5;
    }

    public Name subName(int n, int n2) {
        if (n2 < n) {
            n2 = n;
        }
        return this.table.fromUtf(this.getByteArray(), this.getByteOffset() + n, n2 - n);
    }

    @Override
    public String toString() {
        return Convert.utf2string(this.getByteArray(), this.getByteOffset(), this.getByteLength());
    }

    public byte[] toUtf() {
        byte[] byArray = new byte[this.getByteLength()];
        this.getBytes(byArray, 0);
        return byArray;
    }

    public abstract int getIndex();

    public abstract int getByteLength();

    public abstract byte getByteAt(int var1);

    public void getBytes(byte[] byArray, int n) {
        System.arraycopy(this.getByteArray(), this.getByteOffset(), byArray, n, this.getByteLength());
    }

    public abstract byte[] getByteArray();

    public abstract int getByteOffset();

    public static abstract class Table {
        public final Names names;

        Table(Names names) {
            this.names = names;
        }

        public abstract Name fromChars(char[] var1, int var2, int var3);

        public Name fromString(String string) {
            char[] cArray = string.toCharArray();
            return this.fromChars(cArray, 0, cArray.length);
        }

        public Name fromUtf(byte[] byArray) {
            return this.fromUtf(byArray, 0, byArray.length);
        }

        public abstract Name fromUtf(byte[] var1, int var2, int var3);

        public abstract void dispose();

        protected static int hashValue(byte[] byArray, int n, int n2) {
            int n3 = 0;
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                n3 = (n3 << 5) - n3 + byArray[n4++];
            }
            return n3;
        }

        protected static boolean equals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
            int n4;
            for (n4 = 0; n4 < n3 && byArray[n + n4] == byArray2[n2 + n4]; ++n4) {
            }
            return n4 == n3;
        }
    }
}

