/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.gax.rpc.mtls.MtlsProvider;
import com.google.api.gax.rpc.testing.FakeMtlsProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractMtlsTransportChannelTest {
    protected abstract Object getMtlsObjectFromTransportChannel(MtlsProvider var1) throws IOException, GeneralSecurityException;

    @Test
    public void testNotUseClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(false, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", false);
        Assert.assertNull(this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    public void testUseClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, FakeMtlsProvider.createTestMtlsKeyStore(), "", false);
        Assert.assertNotNull(this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    public void testNoClientCertificate() throws IOException, GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", false);
        Assert.assertNull(this.getMtlsObjectFromTransportChannel(provider));
    }

    @Test
    public void testGetKeyStoreThrows() throws GeneralSecurityException {
        FakeMtlsProvider provider = new FakeMtlsProvider(true, MtlsProvider.MtlsEndpointUsagePolicy.AUTO, null, "", true);
        try {
            this.getMtlsObjectFromTransportChannel(provider);
            Assert.fail("should throw an exception");
        }
        catch (IOException e) {
            Assert.assertTrue("expected getKeyStore to throw an exception", e.getMessage().contains("getKeyStore throws exception"));
        }
    }
}

