/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.protoparser;

import com.google.api.generator.gapic.model.GapicLanguageSettings;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class GapicLanguageSettingsParser {
    private static final String YAML_KEY_LANGUAGE_SETTINGS = "language_settings";
    private static final String YAML_KEY_JAVA = "java";
    private static final String YAML_KEY_PACKAGE_NAME = "package_name";
    private static final String YAML_KEY_INTERFACE_NAMES = "interface_names";

    public static Optional<GapicLanguageSettings> parse(Optional<String> gapicYamlConfigFilePathOpt) {
        return gapicYamlConfigFilePathOpt.isPresent() ? GapicLanguageSettingsParser.parse(gapicYamlConfigFilePathOpt.get()) : Optional.empty();
    }

    @VisibleForTesting
    static Optional<GapicLanguageSettings> parse(String gapicYamlConfigFilePath) {
        if (Strings.isNullOrEmpty(gapicYamlConfigFilePath) || !new File(gapicYamlConfigFilePath).exists()) {
            return Optional.empty();
        }
        String fileContents = null;
        try {
            fileContents = new String(Files.readAllBytes(Paths.get(gapicYamlConfigFilePath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return Optional.empty();
        }
        Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
        Map yamlMap = (Map)yaml.load(fileContents);
        return GapicLanguageSettingsParser.parseFromMap(yamlMap);
    }

    private static Optional<GapicLanguageSettings> parseFromMap(Map<String, Object> yamlMap) {
        if (!yamlMap.containsKey(YAML_KEY_LANGUAGE_SETTINGS)) {
            return Optional.empty();
        }
        Map languageYamlConfig = (Map)yamlMap.get(YAML_KEY_LANGUAGE_SETTINGS);
        if (!languageYamlConfig.containsKey(YAML_KEY_JAVA)) {
            return Optional.empty();
        }
        Map javaYamlConfig = (Map)languageYamlConfig.get(YAML_KEY_JAVA);
        if (!javaYamlConfig.containsKey(YAML_KEY_PACKAGE_NAME)) {
            return Optional.empty();
        }
        GapicLanguageSettings.Builder gapicLanguageSettingsBuilder = GapicLanguageSettings.builder().setPakkage((String)javaYamlConfig.get(YAML_KEY_PACKAGE_NAME));
        if (!javaYamlConfig.containsKey(YAML_KEY_INTERFACE_NAMES)) {
            return Optional.of(gapicLanguageSettingsBuilder.build());
        }
        return Optional.of(gapicLanguageSettingsBuilder.setProtoServiceToJavaClassname((Map)javaYamlConfig.get(YAML_KEY_INTERFACE_NAMES)).build());
    }
}

