/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.test.protoloader;

import com.google.api.Service;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Transport;
import com.google.api.generator.gapic.protoparser.Parser;
import com.google.api.generator.gapic.protoparser.ServiceConfigParser;
import com.google.api.generator.gapic.protoparser.ServiceYamlParser;
import com.google.api.generator.test.protoloader.TestProtoLoader;
import com.google.common.truth.Truth;
import com.google.longrunning.OperationsProto;
import com.google.protobuf.Descriptors;
import com.google.protobuf.StructProto;
import com.google.showcase.grpcrest.v1beta1.EchoGrpcrest;
import com.google.showcase.v1beta1.WickedOuterClass;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.Assert;

public class GrpcRestTestProtoLoader
extends TestProtoLoader {
    private static final GrpcRestTestProtoLoader INSTANCE = new GrpcRestTestProtoLoader();

    protected GrpcRestTestProtoLoader() {
        super(Transport.GRPC_REST, "src/test/resources/");
    }

    public static GrpcRestTestProtoLoader instance() {
        return INSTANCE;
    }

    @Override
    public GapicContext parseShowcaseEcho() {
        Descriptors.FileDescriptor echoFileDescriptor = EchoGrpcrest.getDescriptor();
        Descriptors.ServiceDescriptor echoServiceDescriptor = (Descriptors.ServiceDescriptor)echoFileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Echo", (Object)echoServiceDescriptor.getName());
        String serviceYamlFileName = "echo_v1beta1.yaml";
        Path serviceYamlPath = Paths.get(this.getTestFilesDirectory(), serviceYamlFileName);
        Optional serviceYamlOpt = ServiceYamlParser.parse((String)serviceYamlPath.toString());
        Truth.assertThat((Boolean)serviceYamlOpt.isPresent()).isTrue();
        Service service = (Service)serviceYamlOpt.get();
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)echoFileDescriptor);
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)OperationsProto.getDescriptor()));
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)StructProto.getDescriptor()));
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)echoFileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)echoFileDescriptor, (Map)messageTypes, (Map)resourceNames, (Optional)serviceYamlOpt, outputResourceNames);
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setServiceYamlProto(service).setHelperResourceNames(outputResourceNames).setTransport(this.getTransport()).build();
    }

    public GapicContext parseShowcaseWicked() {
        Descriptors.FileDescriptor fileDescriptor = WickedOuterClass.getDescriptor();
        Descriptors.ServiceDescriptor messagingService = (Descriptors.ServiceDescriptor)fileDescriptor.getServices().get(0);
        Assert.assertEquals((Object)"Wicked", (Object)messagingService.getName());
        Map messageTypes = Parser.parseMessages((Descriptors.FileDescriptor)fileDescriptor);
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)OperationsProto.getDescriptor()));
        messageTypes.putAll(Parser.parseMessages((Descriptors.FileDescriptor)StructProto.getDescriptor()));
        Map resourceNames = Parser.parseResourceNames((Descriptors.FileDescriptor)fileDescriptor);
        HashSet outputResourceNames = new HashSet();
        List services = Parser.parseService((Descriptors.FileDescriptor)fileDescriptor, (Map)messageTypes, (Map)resourceNames, Optional.empty(), outputResourceNames);
        String jsonFilename = "showcase_grpc_service_config.json";
        Path jsonPath = Paths.get(this.getTestFilesDirectory(), jsonFilename);
        Optional configOpt = ServiceConfigParser.parse((String)jsonPath.toString());
        Assert.assertTrue((boolean)configOpt.isPresent());
        GapicServiceConfig config = (GapicServiceConfig)configOpt.get();
        return GapicContext.builder().setMessages(messageTypes).setResourceNames(resourceNames).setServices(services).setServiceConfig(config).setHelperResourceNames(outputResourceNames).setTransport(this.getTransport()).build();
    }
}

