/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.security.trust;

import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.buffer.Unpooled;
import io.grpc.netty.shaded.io.netty.handler.codec.base64.Base64;
import io.grpc.netty.shaded.io.netty.util.CharsetUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CertificateUtils {
    private static final Logger logger = Logger.getLogger(CertificateUtils.class.getName());
    private static CertificateFactory factory;
    private static final Pattern KEY_PATTERN;

    private static synchronized void initInstance() throws CertificateException {
        if (factory == null) {
            factory = CertificateFactory.getInstance("X.509");
        }
    }

    static X509Certificate[] toX509Certificates(File file) throws CertificateException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            X509Certificate[] x509CertificateArray;
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                x509CertificateArray = CertificateUtils.toX509Certificates(bis);
            }
            return x509CertificateArray;
        }
    }

    public static synchronized X509Certificate[] toX509Certificates(InputStream inputStream) throws CertificateException, IOException {
        CertificateUtils.initInstance();
        Collection<? extends Certificate> certs = factory.generateCertificates(inputStream);
        return certs.toArray(new X509Certificate[0]);
    }

    public static synchronized X509Certificate toX509Certificate(InputStream inputStream) throws CertificateException, IOException {
        CertificateUtils.initInstance();
        Certificate cert = factory.generateCertificate(inputStream);
        return (X509Certificate)cert;
    }

    public static PrivateKey getPrivateKey(InputStream inputStream) throws Exception {
        ByteBuf encodedKeyBuf = CertificateUtils.readPrivateKey(inputStream);
        byte[] encodedKey = new byte[encodedKeyBuf.readableBytes()];
        encodedKeyBuf.readBytes(encodedKey).release();
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(encodedKey);
        return KeyFactory.getInstance("RSA").generatePrivate(spec);
    }

    private static ByteBuf readPrivateKey(InputStream in) throws KeyException {
        String content;
        try {
            content = CertificateUtils.readContent(in);
        }
        catch (IOException e) {
            throw new KeyException("failed to read key input stream", e);
        }
        Matcher m4 = KEY_PATTERN.matcher(content);
        if (!m4.find()) {
            throw new KeyException("could not find a PKCS #8 private key in input stream");
        }
        ByteBuf base64 = Unpooled.copiedBuffer(m4.group(1), CharsetUtil.US_ASCII);
        ByteBuf der = Base64.decode(base64);
        base64.release();
        return der;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readContent(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int ret;
            byte[] buf = new byte[8192];
            while ((ret = in.read(buf)) >= 0) {
                out.write(buf, 0, ret);
            }
            String string = out.toString(CharsetUtil.US_ASCII.name());
            return string;
        }
        finally {
            CertificateUtils.safeClose(out);
        }
    }

    private static void safeClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Failed to close a stream.", e);
        }
    }

    private CertificateUtils() {
    }

    static {
        KEY_PATTERN = Pattern.compile("-+BEGIN\\s+.*PRIVATE\\s+KEY[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*PRIVATE\\s+KEY[^-]*-+", 2);
    }
}

